/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.aot;

import io.micronaut.aot.core.AOTContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Collection;

@Internal
public final class AOTContextUtils {
    private AOTContextUtils() {
    }

    @NonNull
    public static <T> Collection<T> getBeansOfType(@NonNull Class<T> beanType, @NonNull AOTContext aotContext) {
        return aotContext.getAnalyzer().getApplicationContext().getBeansOfType(beanType);
    }

    @NonNull
    public static <T> T getBean(@NonNull Class<T> beanType, @NonNull AOTContext aotContext) {
        return (T)aotContext.getAnalyzer().getApplicationContext().getBean(beanType);
    }

    @NonNull
    public static <T> boolean containsBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull AOTContext aotContext) {
        return aotContext.getAnalyzer().getApplicationContext().containsBean(beanType, qualifier);
    }

    @NonNull
    public static <T> T getBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull AOTContext aotContext) {
        return (T)aotContext.getAnalyzer().getApplicationContext().getBean(beanType, qualifier);
    }
}

