/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.aot;

import com.nimbusds.jose.jwk.JWKSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.aot.AOTContextUtils;
import io.micronaut.security.aot.GeneratedFile;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.token.jwt.signature.jwks.DefaultJwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;

@AOTModule(id="micronaut.security.jwks")
public class JwksFetcherCodeGenerator
extends AbstractCodeGenerator {
    public static final String SECURITY_AOT_JWKS_MODULE_ID = "micronaut.security.jwks";
    private static final ParameterizedTypeName SUPPLIER_OF_METADATA = ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{JWKSet.class});

    public void generate(@NonNull AOTContext context) {
        List<GeneratedFile> files = this.generateJavaFiles(context);
        if (!files.isEmpty()) {
            context.registerStaticOptimization("AotJwksFetcher", DefaultJwkSetFetcher.Optimizations.class, body -> {
                body.addStatement("$T configs = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA})});
                for (GeneratedFile generatedFile : files) {
                    context.registerGeneratedSourceFile(generatedFile.getJavaFile());
                    body.addStatement("configs.put($S, $T::create)", new Object[]{generatedFile.getName(), ClassName.bestGuess((String)generatedFile.getSimpleName())});
                }
                body.addStatement("return new $T(configs)", new Object[]{DefaultJwkSetFetcher.Optimizations.class});
            });
        }
    }

    @NonNull
    private Set<String> jwksUrls(@NonNull AOTContext context) {
        HashSet<String> urls = new HashSet<String>();
        AOTContextUtils.getBeansOfType(JwksSignatureConfiguration.class, context).stream().map(JwksSignatureConfiguration::getUrl).forEach(urls::add);
        AOTContextUtils.getBeansOfType(OpenIdProviderMetadata.class, context).stream().map(OpenIdProviderMetadata::getJwksUri).filter(Objects::nonNull).forEach(urls::add);
        return urls;
    }

    private List<GeneratedFile> generateJavaFiles(@NonNull AOTContext context) {
        Set<String> urls = this.jwksUrls(context);
        JwkSetFetcher jwkSetFetcher = AOTContextUtils.getBean(JwkSetFetcher.class, context);
        int count = 0;
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        for (String url : urls) {
            Optional<GeneratedFile> generatedFile = this.generatedFile(context, jwkSetFetcher, url, count);
            if (!generatedFile.isPresent()) continue;
            result.add(generatedFile.get());
            ++count;
        }
        return result;
    }

    private Optional<GeneratedFile> generatedFile(AOTContext aotContext, JwkSetFetcher<?> jwkSetFetcher, String url, int count) {
        Object obj;
        Optional jwkSetOptional = jwkSetFetcher.fetch(url);
        if (jwkSetOptional.isPresent() && (obj = jwkSetOptional.get()) instanceof JWKSet) {
            JWKSet jwkSet = (JWKSet)obj;
            String json = jwkSet.toString(false);
            String simpleName = "Aot" + JwkSetFetcher.class.getSimpleName() + count;
            return Optional.of(new GeneratedFile(url, simpleName, this.generateJavaFile(aotContext, simpleName, json)));
        }
        return Optional.empty();
    }

    private JavaFile generateJavaFile(@NonNull AOTContext context, @NonNull String fileSimpleName, @NonNull String json) {
        return context.javaFile(TypeSpec.classBuilder((String)fileSimpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.generateMethod(json)).build());
    }

    @NonNull
    private MethodSpec generateMethod(@NonNull String json) {
        return MethodSpec.methodBuilder((String)"create").returns(JWKSet.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).beginControlFlow("try", new Object[0]).addStatement("return JWKSet.parse($S)", new Object[]{json}).nextControlFlow("catch ($T e)", new Object[]{ParseException.class}).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow().build();
    }
}

