/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.jackson.JacksonConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;

@Produces
@Singleton
@Requires(classes={ConstraintViolationException.class, ExceptionHandler.class})
public class ConstraintExceptionHandler
implements ExceptionHandler<ConstraintViolationException, HttpResponse<?>> {
    private final boolean alwaysSerializeErrorsAsList;
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public ConstraintExceptionHandler() {
        this.alwaysSerializeErrorsAsList = false;
        this.responseProcessor = null;
    }

    @Deprecated
    public ConstraintExceptionHandler(JacksonConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
        this.responseProcessor = null;
    }

    @Inject
    public ConstraintExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.alwaysSerializeErrorsAsList = false;
        this.responseProcessor = responseProcessor;
    }

    public HttpResponse<?> handle(HttpRequest request, ConstraintViolationException exception) {
        Set constraintViolations = exception.getConstraintViolations();
        if (this.responseProcessor != null) {
            MutableHttpResponse response = HttpResponse.badRequest();
            ErrorContext.Builder contextBuilder = ErrorContext.builder((HttpRequest)request).cause((Throwable)exception);
            if (constraintViolations == null || constraintViolations.isEmpty()) {
                return this.responseProcessor.processResponse(contextBuilder.errorMessage(exception.getMessage() == null ? HttpStatus.BAD_REQUEST.getReason() : exception.getMessage()).build(), response);
            }
            return this.responseProcessor.processResponse(contextBuilder.errorMessages(exception.getConstraintViolations().stream().map(this::buildMessage).collect(Collectors.toList())).build(), response);
        }
        if (constraintViolations == null || constraintViolations.isEmpty()) {
            JsonError error = new JsonError(exception.getMessage() == null ? HttpStatus.BAD_REQUEST.getReason() : exception.getMessage());
            error.link(Link.SELF, Link.of((URI)request.getUri()));
            return HttpResponse.badRequest((Object)error);
        }
        if (constraintViolations.size() == 1 && !this.alwaysSerializeErrorsAsList) {
            ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
            JsonError error = new JsonError(this.buildMessage(violation));
            error.link(Link.SELF, Link.of((URI)request.getUri()));
            return HttpResponse.badRequest((Object)error);
        }
        JsonError error = new JsonError(HttpStatus.BAD_REQUEST.getReason());
        ArrayList<JsonError> errors = new ArrayList<JsonError>();
        for (ConstraintViolation violation : constraintViolations) {
            errors.add(new JsonError(this.buildMessage(violation)));
        }
        error.embedded((CharSequence)"errors", errors);
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.badRequest((Object)error);
    }

    protected String buildMessage(ConstraintViolation violation) {
        Path propertyPath = violation.getPropertyPath();
        StringBuilder message = new StringBuilder();
        Iterator i = propertyPath.iterator();
        while (i.hasNext()) {
            Path.Node node = (Path.Node)i.next();
            if (node.getKind() == ElementKind.METHOD || node.getKind() == ElementKind.CONSTRUCTOR) continue;
            message.append(node.getName());
            if (!i.hasNext()) continue;
            message.append('.');
        }
        message.append(": ").append(violation.getMessage());
        return message.toString();
    }
}

