/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.DecimalMaxValidator;
import io.micronaut.validation.validator.constraints.DecimalMinValidator;
import io.micronaut.validation.validator.constraints.DigitsValidator;
import io.micronaut.validation.validator.constraints.EmailValidator;
import io.micronaut.validation.validator.constraints.PatternValidator;
import io.micronaut.validation.validator.constraints.SizeValidator;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;

@Singleton
@Introspected
public class DefaultConstraintValidators
implements ConstraintValidatorRegistry {
    private final Map<ValidatorKey, ConstraintValidator> validatorCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(10).maximumWeightedCapacity(40L).build();
    private final ConstraintValidator<AssertFalse, Boolean> assertFalseValidator = (value, annotationMetadata, context) -> value == null || value == false;
    private final ConstraintValidator<AssertTrue, Boolean> assertTrueValidator = (value, annotationMetadata, context) -> value == null || value != false;
    private final DecimalMaxValidator<CharSequence> decimalMaxValidatorCharSequence = (value, bigDecimal) -> new BigDecimal(value.toString()).compareTo(bigDecimal);
    private final DecimalMaxValidator<Number> decimalMaxValidatorNumber = DefaultConstraintValidators::compareNumber;
    private final DecimalMinValidator<CharSequence> decimalMinValidatorCharSequence = (value, bigDecimal) -> new BigDecimal(value.toString()).compareTo(bigDecimal);
    private final DecimalMinValidator<Number> decimalMinValidatorNumber = DefaultConstraintValidators::compareNumber;
    private final DigitsValidator<Number> digitsValidatorNumber = value -> {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    };
    private final DigitsValidator<CharSequence> digitsValidatorCharSequence = value -> new BigDecimal(value.toString());
    private final ConstraintValidator<Max, Number> maxNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Long max = (Long)annotationMetadata.getValue(Long.class).orElseThrow(() -> new ValidationException("@Max annotation specified without value"));
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(max)) < 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(max)) < 0;
        }
        return value.longValue() <= max;
    };
    private final ConstraintValidator<Min, Number> minNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Long max = (Long)annotationMetadata.getValue(Long.class).orElseThrow(() -> new ValidationException("@Min annotation specified without value"));
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(max)) >= 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(max)) >= 0;
        }
        return value.longValue() >= max;
    };
    private final ConstraintValidator<Negative, Number> negativeNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).signum() < 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() < 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() < 0.0;
        }
        return value.longValue() < 0L;
    };
    private final ConstraintValidator<NegativeOrZero, Number> negativeOrZeroNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).signum() <= 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() <= 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() <= 0.0;
        }
        return value.longValue() <= 0L;
    };
    private final ConstraintValidator<Positive, Number> positiveNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).signum() > 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() > 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() > 0.0;
        }
        return value.longValue() > 0L;
    };
    private final ConstraintValidator<PositiveOrZero, Number> positiveOrZeroNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).signum() >= 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() >= 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() >= 0.0;
        }
        return value.longValue() >= 0L;
    };
    private final ConstraintValidator<NotBlank, CharSequence> notBlankValidator = (value, annotationMetadata, context) -> StringUtils.isNotEmpty((CharSequence)value) && value.toString().trim().length() > 0;
    private final ConstraintValidator<NotNull, Object> notNullValidator = (value, annotationMetadata, context) -> value != null;
    private final ConstraintValidator<Null, Object> nullValidator = (value, annotationMetadata, context) -> value == null;
    private final ConstraintValidator<NotEmpty, byte[]> notEmptyByteArrayValidator = (value, annotationMetadata, context) -> value != null && ((byte[])value).length > 0;
    private final ConstraintValidator<NotEmpty, char[]> notEmptyCharArrayValidator = (value, annotationMetadata, context) -> value != null && ((char[])value).length > 0;
    private final ConstraintValidator<NotEmpty, boolean[]> notEmptyBooleanArrayValidator = (value, annotationMetadata, context) -> value != null && ((boolean[])value).length > 0;
    private final ConstraintValidator<NotEmpty, double[]> notEmptyDoubleArrayValidator = (value, annotationMetadata, context) -> value != null && ((double[])value).length > 0;
    private final ConstraintValidator<NotEmpty, float[]> notEmptyFloatArrayValidator = (value, annotationMetadata, context) -> value != null && ((float[])value).length > 0;
    private final ConstraintValidator<NotEmpty, int[]> notEmptyIntArrayValidator = (value, annotationMetadata, context) -> value != null && ((int[])value).length > 0;
    private final ConstraintValidator<NotEmpty, long[]> notEmptyLongArrayValidator = (value, annotationMetadata, context) -> value != null && ((long[])value).length > 0;
    private final ConstraintValidator<NotEmpty, Object[]> notEmptyObjectArrayValidator = (value, annotationMetadata, context) -> value != null && ((Object[])value).length > 0;
    private final ConstraintValidator<NotEmpty, short[]> notEmptyShortArrayValidator = (value, annotationMetadata, context) -> value != null && ((short[])value).length > 0;
    private final ConstraintValidator<NotEmpty, CharSequence> notEmptyCharSequenceValidator = (value, annotationMetadata, context) -> StringUtils.isNotEmpty((CharSequence)value);
    private final ConstraintValidator<NotEmpty, Collection> notEmptyCollectionValidator = (value, annotationMetadata, context) -> CollectionUtils.isNotEmpty((Collection)value);
    private final ConstraintValidator<NotEmpty, Map> notEmptyMapValidator = (value, annotationMetadata, context) -> CollectionUtils.isNotEmpty((Map)value);
    private final SizeValidator<Object[]> sizeObjectArrayValidator = value -> ((Object[])value).length;
    private final SizeValidator<byte[]> sizeByteArrayValidator = value -> ((byte[])value).length;
    private final SizeValidator<char[]> sizeCharArrayValidator = value -> ((char[])value).length;
    private final SizeValidator<boolean[]> sizeBooleanArrayValidator = value -> ((boolean[])value).length;
    private final SizeValidator<double[]> sizeDoubleArrayValidator = value -> ((double[])value).length;
    private final SizeValidator<float[]> sizeFloatArrayValidator = value -> ((float[])value).length;
    private final SizeValidator<int[]> sizeIntArrayValidator = value -> ((int[])value).length;
    private final SizeValidator<long[]> sizeLongArrayValidator = value -> ((long[])value).length;
    private final SizeValidator<short[]> sizeShortArrayValidator = value -> ((short[])value).length;
    private final SizeValidator<CharSequence> sizeCharSequenceValidator = CharSequence::length;
    private final SizeValidator<Collection> sizeCollectionValidator = Collection::size;
    private final SizeValidator<Map> sizeMapValidator = Map::size;
    private final ConstraintValidator<Past, TemporalAccessor> pastTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = this.getNow((TemporalAccessor)value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) > 0;
    };
    private final ConstraintValidator<PastOrPresent, TemporalAccessor> pastOrPresentTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = this.getNow((TemporalAccessor)value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) >= 0;
    };
    private final ConstraintValidator<Future, TemporalAccessor> futureTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = this.getNow((TemporalAccessor)value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) < 0;
    };
    private final ConstraintValidator<FutureOrPresent, TemporalAccessor> futureOrPresentTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = this.getNow((TemporalAccessor)value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) <= 0;
    };
    @Nullable
    private final BeanContext beanContext;
    private final Map<ValidatorKey, ConstraintValidator> localValidators;

    public DefaultConstraintValidators() {
        this(null);
    }

    @Inject
    protected DefaultConstraintValidators(@Nullable BeanContext beanContext) {
        this.beanContext = beanContext;
        BeanWrapper wrapper = BeanWrapper.findWrapper(DefaultConstraintValidators.class, (Object)this).orElse(null);
        if (wrapper != null) {
            Collection beanProperties = wrapper.getBeanProperties();
            HashMap<ValidatorKey, ConstraintValidator> validatorMap = new HashMap<ValidatorKey, ConstraintValidator>(beanProperties.size());
            for (BeanProperty property : beanProperties) {
                Object[] typeParameters;
                if (!ConstraintValidator.class.isAssignableFrom(property.getType()) || !ArrayUtils.isNotEmpty((Object[])(typeParameters = property.asArgument().getTypeParameters()))) continue;
                int len = typeParameters.length;
                wrapper.getProperty(property.getName(), ConstraintValidator.class).ifPresent(arg_0 -> this.lambda$new$42(len, (Argument[])typeParameters, validatorMap, arg_0));
            }
            validatorMap.put(new ValidatorKey<Pattern, CharSequence>(Pattern.class, CharSequence.class), new PatternValidator());
            validatorMap.put(new ValidatorKey<Email, CharSequence>(Email.class, CharSequence.class), new EmailValidator());
            this.localValidators = validatorMap;
        } else {
            this.localValidators = Collections.emptyMap();
        }
    }

    @Override
    @Nonnull
    public <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findConstraintValidator(@Nonnull Class<A> constraintType, @Nonnull Class<T> targetType) {
        ArgumentUtils.requireNonNull((String)"constraintType", constraintType);
        ArgumentUtils.requireNonNull((String)"targetType", targetType);
        ValidatorKey<A, T> key = new ValidatorKey<A, T>(constraintType, targetType);
        targetType = ReflectionUtils.getWrapperType(targetType);
        ConstraintValidator constraintValidator = this.localValidators.get(key);
        if (constraintValidator != null) {
            return Optional.of(constraintValidator);
        }
        constraintValidator = this.validatorCache.get(key);
        if (constraintValidator != null) {
            return Optional.of(constraintValidator);
        }
        Qualifier qualifier = Qualifiers.byTypeArguments((Class[])new Class[]{constraintType, ReflectionUtils.getWrapperType((Class)targetType)});
        Class finalTargetType = targetType;
        Optional<ConstraintValidator<A, T>> local = this.localValidators.entrySet().stream().filter(entry -> {
            ValidatorKey k = (ValidatorKey)entry.getKey();
            return TypeArgumentQualifier.areTypesCompatible((Class[])new Class[]{constraintType, finalTargetType}, Arrays.asList(k.constraintType, k.targetType));
        }).map(Map.Entry::getValue).findFirst();
        if (local.isPresent()) {
            this.validatorCache.put(key, local.get());
            return local;
        }
        if (this.beanContext != null) {
            ConstraintValidator cv = this.beanContext.findBean(ConstraintValidator.class, qualifier).orElse(ConstraintValidator.VALID);
            this.validatorCache.put(key, cv);
            if (cv != ConstraintValidator.VALID) {
                return Optional.of(cv);
            }
        } else {
            ConstraintValidator cv = this.findLocalConstraintValidator(constraintType, targetType).orElse(ConstraintValidator.VALID);
            this.validatorCache.put(key, cv);
            if (cv != ConstraintValidator.VALID) {
                return Optional.of(cv);
            }
        }
        return Optional.empty();
    }

    public ConstraintValidator<AssertFalse, Boolean> getAssertFalseValidator() {
        return this.assertFalseValidator;
    }

    public ConstraintValidator<AssertTrue, Boolean> getAssertTrueValidator() {
        return this.assertTrueValidator;
    }

    public DecimalMaxValidator<CharSequence> getDecimalMaxValidatorCharSequence() {
        return this.decimalMaxValidatorCharSequence;
    }

    public DecimalMaxValidator<Number> getDecimalMaxValidatorNumber() {
        return this.decimalMaxValidatorNumber;
    }

    public DecimalMinValidator<CharSequence> getDecimalMinValidatorCharSequence() {
        return this.decimalMinValidatorCharSequence;
    }

    public DecimalMinValidator<Number> getDecimalMinValidatorNumber() {
        return this.decimalMinValidatorNumber;
    }

    public DigitsValidator<Number> getDigitsValidatorNumber() {
        return this.digitsValidatorNumber;
    }

    public DigitsValidator<CharSequence> getDigitsValidatorCharSequence() {
        return this.digitsValidatorCharSequence;
    }

    public ConstraintValidator<Max, Number> getMaxNumberValidator() {
        return this.maxNumberValidator;
    }

    public ConstraintValidator<Min, Number> getMinNumberValidator() {
        return this.minNumberValidator;
    }

    public ConstraintValidator<Negative, Number> getNegativeNumberValidator() {
        return this.negativeNumberValidator;
    }

    public ConstraintValidator<NegativeOrZero, Number> getNegativeOrZeroNumberValidator() {
        return this.negativeOrZeroNumberValidator;
    }

    public ConstraintValidator<Positive, Number> getPositiveNumberValidator() {
        return this.positiveNumberValidator;
    }

    public ConstraintValidator<PositiveOrZero, Number> getPositiveOrZeroNumberValidator() {
        return this.positiveOrZeroNumberValidator;
    }

    public ConstraintValidator<NotBlank, CharSequence> getNotBlankValidator() {
        return this.notBlankValidator;
    }

    public ConstraintValidator<NotNull, Object> getNotNullValidator() {
        return this.notNullValidator;
    }

    public ConstraintValidator<Null, Object> getNullValidator() {
        return this.nullValidator;
    }

    public ConstraintValidator<NotEmpty, byte[]> getNotEmptyByteArrayValidator() {
        return this.notEmptyByteArrayValidator;
    }

    public ConstraintValidator<NotEmpty, char[]> getNotEmptyCharArrayValidator() {
        return this.notEmptyCharArrayValidator;
    }

    public ConstraintValidator<NotEmpty, boolean[]> getNotEmptyBooleanArrayValidator() {
        return this.notEmptyBooleanArrayValidator;
    }

    public ConstraintValidator<NotEmpty, double[]> getNotEmptyDoubleArrayValidator() {
        return this.notEmptyDoubleArrayValidator;
    }

    public ConstraintValidator<NotEmpty, float[]> getNotEmptyFloatArrayValidator() {
        return this.notEmptyFloatArrayValidator;
    }

    public ConstraintValidator<NotEmpty, int[]> getNotEmptyIntArrayValidator() {
        return this.notEmptyIntArrayValidator;
    }

    public ConstraintValidator<NotEmpty, long[]> getNotEmptyLongArrayValidator() {
        return this.notEmptyLongArrayValidator;
    }

    public ConstraintValidator<NotEmpty, Object[]> getNotEmptyObjectArrayValidator() {
        return this.notEmptyObjectArrayValidator;
    }

    public ConstraintValidator<NotEmpty, short[]> getNotEmptyShortArrayValidator() {
        return this.notEmptyShortArrayValidator;
    }

    public ConstraintValidator<NotEmpty, CharSequence> getNotEmptyCharSequenceValidator() {
        return this.notEmptyCharSequenceValidator;
    }

    public ConstraintValidator<NotEmpty, Collection> getNotEmptyCollectionValidator() {
        return this.notEmptyCollectionValidator;
    }

    public ConstraintValidator<NotEmpty, Map> getNotEmptyMapValidator() {
        return this.notEmptyMapValidator;
    }

    public SizeValidator<Object[]> getSizeObjectArrayValidator() {
        return this.sizeObjectArrayValidator;
    }

    public SizeValidator<byte[]> getSizeByteArrayValidator() {
        return this.sizeByteArrayValidator;
    }

    public SizeValidator<char[]> getSizeCharArrayValidator() {
        return this.sizeCharArrayValidator;
    }

    public SizeValidator<boolean[]> getSizeBooleanArrayValidator() {
        return this.sizeBooleanArrayValidator;
    }

    public SizeValidator<double[]> getSizeDoubleArrayValidator() {
        return this.sizeDoubleArrayValidator;
    }

    public SizeValidator<float[]> getSizeFloatArrayValidator() {
        return this.sizeFloatArrayValidator;
    }

    public SizeValidator<int[]> getSizeIntArrayValidator() {
        return this.sizeIntArrayValidator;
    }

    public SizeValidator<long[]> getSizeLongArrayValidator() {
        return this.sizeLongArrayValidator;
    }

    public SizeValidator<short[]> getSizeShortArrayValidator() {
        return this.sizeShortArrayValidator;
    }

    public SizeValidator<CharSequence> getSizeCharSequenceValidator() {
        return this.sizeCharSequenceValidator;
    }

    public SizeValidator<Collection> getSizeCollectionValidator() {
        return this.sizeCollectionValidator;
    }

    public SizeValidator<Map> getSizeMapValidator() {
        return this.sizeMapValidator;
    }

    public ConstraintValidator<Past, TemporalAccessor> getPastTemporalAccessorConstraintValidator() {
        return this.pastTemporalAccessorConstraintValidator;
    }

    public ConstraintValidator<PastOrPresent, TemporalAccessor> getPastOrPresentTemporalAccessorConstraintValidator() {
        return this.pastOrPresentTemporalAccessorConstraintValidator;
    }

    public ConstraintValidator<Future, TemporalAccessor> getFutureTemporalAccessorConstraintValidator() {
        return this.futureTemporalAccessorConstraintValidator;
    }

    public ConstraintValidator<FutureOrPresent, TemporalAccessor> getFutureOrPresentTemporalAccessorConstraintValidator() {
        return this.futureOrPresentTemporalAccessorConstraintValidator;
    }

    protected <A extends Annotation, T> Optional<ConstraintValidator> findLocalConstraintValidator(@Nonnull Class<A> constraintType, @Nonnull Class<T> targetType) {
        return Optional.empty();
    }

    private Comparable<? extends TemporalAccessor> getNow(TemporalAccessor value, Clock clock) {
        if (!(value instanceof Comparable)) {
            throw new IllegalArgumentException("TemporalAccessor value must be comparable");
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now(clock);
        }
        if (value instanceof Instant) {
            return Instant.now(clock);
        }
        if (value instanceof ZonedDateTime) {
            return ZonedDateTime.now(clock);
        }
        if (value instanceof OffsetDateTime) {
            return OffsetDateTime.now(clock);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now(clock);
        }
        if (value instanceof LocalTime) {
            return LocalTime.now(clock);
        }
        if (value instanceof OffsetTime) {
            return OffsetTime.now(clock);
        }
        if (value instanceof MonthDay) {
            return MonthDay.now(clock);
        }
        if (value instanceof Year) {
            return Year.now(clock);
        }
        if (value instanceof YearMonth) {
            return YearMonth.now(clock);
        }
        if (value instanceof HijrahDate) {
            return HijrahDate.now(clock);
        }
        if (value instanceof JapaneseDate) {
            return JapaneseDate.now(clock);
        }
        if (value instanceof ThaiBuddhistDate) {
            return ThaiBuddhistDate.now(clock);
        }
        if (value instanceof MinguoDate) {
            return MinguoDate.now(clock);
        }
        throw new IllegalArgumentException("TemporalAccessor value type not supported: " + value.getClass());
    }

    private static int compareNumber(@Nonnull Number value, @Nonnull BigDecimal bigDecimal) {
        int result = value instanceof BigDecimal ? ((BigDecimal)value).compareTo(bigDecimal) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value).compareTo(bigDecimal) : BigDecimal.valueOf(value.doubleValue()).compareTo(bigDecimal));
        return result;
    }

    private /* synthetic */ void lambda$new$42(int len, Argument[] typeParameters, Map validatorMap, ConstraintValidator constraintValidator) {
        if (len == 2) {
            Class targetType = ReflectionUtils.getWrapperType((Class)typeParameters[1].getType());
            ValidatorKey key = new ValidatorKey(typeParameters[0].getType(), targetType);
            validatorMap.put(key, constraintValidator);
        } else if (len == 1) {
            if (constraintValidator instanceof SizeValidator) {
                ValidatorKey key = new ValidatorKey(Size.class, typeParameters[0].getType());
                validatorMap.put(key, constraintValidator);
            } else if (constraintValidator instanceof DigitsValidator) {
                ValidatorKey key = new ValidatorKey(Digits.class, typeParameters[0].getType());
                validatorMap.put(key, constraintValidator);
            } else if (constraintValidator instanceof DecimalMaxValidator) {
                ValidatorKey key = new ValidatorKey(DecimalMax.class, typeParameters[0].getType());
                validatorMap.put(key, constraintValidator);
            } else if (constraintValidator instanceof DecimalMinValidator) {
                ValidatorKey key = new ValidatorKey(DecimalMin.class, typeParameters[0].getType());
                validatorMap.put(key, constraintValidator);
            }
        }
    }

    protected final class ValidatorKey<A extends Annotation, T> {
        private final Class<A> constraintType;
        private final Class<T> targetType;

        public ValidatorKey(@Nonnull Class<A> constraintType, Class<T> targetType) {
            this.constraintType = constraintType;
            this.targetType = targetType;
        }

        public Class<A> getConstraintType() {
            return this.constraintType;
        }

        public Class<T> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidatorKey key = (ValidatorKey)o;
            return this.constraintType.equals(key.constraintType) && this.targetType.equals(key.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.constraintType, this.targetType);
        }
    }
}

