/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.validation.routes.RouteParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.MissingParameterRule;
import io.micronaut.validation.routes.rules.NullableParameterRule;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RouteValidationVisitor
implements TypeElementVisitor<Object, HttpMethodMapping> {
    private List<RouteValidationRule> rules = new ArrayList<RouteValidationRule>();
    private boolean skipValidation = false;
    private final DefaultPropertyPlaceholderResolver resolver = new DefaultPropertyPlaceholderResolver(null, (ConversionService)new DefaultConversionService());

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.skipValidation) {
            return;
        }
        AnnotationValue mappingAnnotation = element.getAnnotation(HttpMethodMapping.class);
        if (mappingAnnotation != null) {
            String uri = (String)mappingAnnotation.getRequiredValue(String.class);
            List segments = this.resolver.buildSegments(uri);
            StringBuilder uriValue = new StringBuilder();
            for (DefaultPropertyPlaceholderResolver.Segment segment : segments) {
                if (segment instanceof DefaultPropertyPlaceholderResolver.RawSegment) {
                    uriValue.append((String)segment.getValue(String.class));
                    continue;
                }
                uriValue.append("tmp");
            }
            UriMatchTemplate template = UriMatchTemplate.of((String)uriValue.toString());
            ParameterElement[] parameters = (RouteParameterElement[])Arrays.stream(element.getParameters()).map(RouteParameterElement::new).toArray(RouteParameterElement[]::new);
            for (RouteValidationRule rule : this.rules) {
                RouteValidationResult result = rule.validate(template, parameters);
                if (result.isValid()) continue;
                for (String err : result.getErrorMessages()) {
                    context.fail(err, (Element)element);
                }
            }
        }
    }

    public void start(VisitorContext visitorContext) {
        String prop = System.getProperty("micronaut.route.validation");
        this.skipValidation = prop != null && prop.equals("false");
        this.rules.add(new MissingParameterRule());
        this.rules.add(new NullableParameterRule());
    }
}

