/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@ConfigurationProperties(value="micronaut.session")
public class SessionConfiguration {
    public static final int DEFAULT_MAXINACTIVEINTERVAL_MINUTES = 30;
    private Duration maxInactiveInterval = Duration.ofMinutes(30L);
    private Integer maxActiveSessions;
    private boolean promptExpiration = false;
    private BeanProvider<ExecutorService> executorService;

    public OptionalInt getMaxActiveSessions() {
        return this.maxActiveSessions != null ? OptionalInt.of(this.maxActiveSessions) : OptionalInt.empty();
    }

    public void setMaxActiveSessions(Integer maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        if (maxInactiveInterval != null) {
            this.maxInactiveInterval = maxInactiveInterval;
        }
    }

    public boolean isPromptExpiration() {
        return this.promptExpiration;
    }

    public void setPromptExpiration(boolean promptExpiration) {
        this.promptExpiration = promptExpiration;
    }

    public Optional<ScheduledExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService).map(BeanProvider::get).filter(ScheduledExecutorService.class::isInstance).map(ScheduledExecutorService.class::cast);
    }

    @Inject
    public void setExecutorService(@Nullable @Named(value="scheduled") BeanProvider<ExecutorService> executorService) {
        this.executorService = executorService;
    }
}

