/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.micronaut.session.Session;
import io.micronaut.session.http.SessionForRequest;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Set;

public class SessionLogElement
implements LogElement {
    public static final String SESSION = "u";
    private static final AttributeKey<NettyHttpRequest> KEY = AttributeKey.valueOf((String)NettyHttpRequest.class.getSimpleName());
    private final String property;

    SessionLogElement(String property) {
        this.property = property;
    }

    public LogElement copy() {
        return this;
    }

    public String onResponseHeaders(ChannelHandlerContext ctx, HttpHeaders headers, String status) {
        Attribute attr = ctx.channel().attr(KEY);
        NettyHttpRequest request = (NettyHttpRequest)attr.get();
        if (request == null) {
            return "-";
        }
        return SessionForRequest.find(request).map(this::value).orElse("-");
    }

    private String value(Session session) {
        return this.property == null ? session.getId() : session.get(this.property).map(Object::toString).orElse("-");
    }

    public Set<LogElement.Event> events() {
        return LogElement.Event.RESPONSE_HEADERS_EVENTS;
    }

    public String toString() {
        return "%u";
    }
}

