/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.binder;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionFilter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(classes={HttpServerConfiguration.class})
public class OptionalSessionArgumentBinder
implements TypedRequestArgumentBinder<Optional<Session>> {
    public Argument<Optional<Session>> argumentType() {
        Argument argument = Argument.of(Optional.class, (Class[])new Class[]{Session.class});
        return argument;
    }

    public ArgumentBinder.BindingResult<Optional<Session>> bind(ArgumentConversionContext<Optional<Session>> context, HttpRequest<?> source) {
        MutableConvertibleValues attrs = source.getAttributes();
        if (!attrs.contains(OncePerRequestHttpServerFilter.getKey(HttpSessionFilter.class))) {
            return ArgumentBinder.BindingResult.UNSATISFIED;
        }
        Optional existing = attrs.get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (existing.isPresent()) {
            return () -> Optional.of(existing);
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

