/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch.osx;

import com.sun.jna.Library;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.scheduling.io.watch.DefaultWatchThread;
import io.micronaut.scheduling.io.watch.FileWatchCondition;
import io.micronaut.scheduling.io.watch.FileWatchConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

@Replaces(value=DefaultWatchThread.class)
@Parallel
@Requirements(value={@Requires(property="micronaut.io.watch.enabled", value="true", defaultValue="true"), @Requires(condition=FileWatchCondition.class), @Requires(classes={MacOSXListeningWatchService.class, Library.class})})
@Singleton
public class MacOsWatchThread
extends DefaultWatchThread {
    public MacOsWatchThread(ApplicationEventPublisher eventPublisher, FileWatchConfiguration configuration, WatchService watchService) {
        super(eventPublisher, configuration, watchService);
    }

    @NonNull
    protected WatchKey registerPath(@NonNull Path dir) throws IOException {
        WatchablePath watchPath = new WatchablePath(dir);
        return watchPath.register(this.getWatchService(), new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY});
    }

    protected void closeWatchService() {
    }
}

