/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.tree;

import io.micronaut.json.tree.JsonScalar;
import org.jspecify.annotations.NonNull;

final class JsonBoolean
extends JsonScalar {
    private static final JsonBoolean TRUE = new JsonBoolean(true);
    private static final JsonBoolean FALSE = new JsonBoolean(false);
    private final boolean value;

    private JsonBoolean(boolean value) {
        this.value = value;
    }

    static JsonBoolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public @NonNull String coerceStringValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBooleanValue() {
        return this.value;
    }
}

