/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.json.tree.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.NonNull;

@Internal
public class JsonNodeConvertibleValues<V>
implements ConvertibleValues<V> {
    private final JsonNode objectNode;
    private final ConversionService conversionService;

    public JsonNodeConvertibleValues(JsonNode objectNode, ConversionService conversionService) {
        if (!objectNode.isObject()) {
            throw new IllegalArgumentException("Expected object node");
        }
        this.objectNode = objectNode;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Map.Entry<String, JsonNode> entry : this.objectNode.entries()) {
            set.add(entry.getKey());
        }
        return Collections.unmodifiableSet(set);
    }

    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.objectNode.values().forEach(v -> values.add(v));
        return Collections.unmodifiableCollection(values);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String fieldName = name.toString();
        JsonNode jsonNode = this.objectNode.get(fieldName);
        if (jsonNode == null) {
            return Optional.empty();
        }
        return this.conversionService.convert((Object)jsonNode, conversionContext);
    }

    public @NonNull ConversionService getConversionService() {
        return this.conversionService;
    }
}

