/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.CustomizableJsonHandler;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;

@Order(value=-10)
@Singleton
@ProducesJson
@ConsumesJson
@BootstrapContextCompatible
public final class JsonMessageHandler<T>
implements MessageBodyHandler<T>,
CustomizableJsonHandler,
ResponseBodyWriter<T> {
    public static final int ORDER = -10;
    private final JsonMapper jsonMapper;

    public JsonMessageHandler(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public @NonNull JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public boolean isReadable(@NonNull Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.matchesAllOrWildcardOrExtension("json");
    }

    private static CodecException decorateRead(Argument<?> type, IOException e) {
        return new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
    }

    public JsonMessageHandler<T> createSpecific(@NonNull Argument<T> type) {
        return new JsonMessageHandler<T>(this.jsonMapper.createSpecific(type));
    }

    public T read(@NonNull Argument<T> type, MediaType mediaType, @NonNull Headers httpHeaders, @NonNull ByteBuffer<?> byteBuffer) throws CodecException {
        T decoded;
        try {
            decoded = this.jsonMapper.readValue(byteBuffer, type);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateRead(type, e);
        }
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return decoded;
    }

    public T read(@NonNull Argument<T> type, MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        try {
            return this.jsonMapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateRead(type, e);
        }
    }

    public boolean isWriteable(@NonNull Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.matchesAllOrWildcardOrExtension("json");
    }

    private static CodecException decorateWrite(Object object, IOException e) {
        return new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
    }

    public void writeTo(Argument<T> type, @NonNull MediaType mediaType, T object, MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)(mediaType != null ? mediaType : MediaType.APPLICATION_JSON_TYPE));
        try {
            if (type.getType() == Object.class && object instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                outputStream.write(charSequence.toString().getBytes(MessageBodyWriter.findCharset((MediaType)mediaType, (Headers)outgoingHeaders).orElse(StandardCharsets.UTF_8)));
                return;
            }
            this.jsonMapper.writeValue(outputStream, type, object);
        }
        catch (IOException e) {
            throw JsonMessageHandler.decorateWrite(object, e);
        }
    }

    public @NonNull CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) throws CodecException {
        try {
            return bodyFactory.buffer(s -> this.jsonMapper.writeValue((OutputStream)s, object));
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + String.valueOf(object) + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CustomizableJsonHandler customize(JsonFeatures jsonFeatures) {
        return new JsonMessageHandler<T>(this.jsonMapper.cloneWithFeatures(jsonFeatures));
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    @Consumes(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/problem+json", "application/json-patch+json", "application/merge-patch+json", "application/schema+json"})
    public static @interface ConsumesJson {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    @Produces(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/problem+json", "application/json-patch+json", "application/merge-patch+json", "application/schema+json"})
    public static @interface ProducesJson {
    }
}

