/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.hateoas.Resource;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.util.NameTransformer;

@Internal
@Singleton
class ResourceSerializerModifier
extends ValueSerializerModifier {
    ResourceSerializerModifier() {
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription.Supplier supplier, List<BeanPropertyWriter> beanProperties) {
        if (Resource.class.isAssignableFrom(supplier.getBeanClass())) {
            Iterator<BeanPropertyWriter> i = beanProperties.iterator();
            BeanPropertyWriter links = null;
            BeanPropertyWriter embedded = null;
            while (i.hasNext()) {
                BeanPropertyWriter writer = i.next();
                String name = writer.getName();
                if (name.equals("links")) {
                    i.remove();
                    links = writer;
                }
                if (!name.equals("embedded")) continue;
                i.remove();
                embedded = writer;
            }
            if (embedded != null) {
                embedded = embedded.rename(new NameTransformer(this){

                    public String transform(String name) {
                        return "_embedded";
                    }

                    public String reverse(String transformed) {
                        return transformed;
                    }
                });
                beanProperties.add(0, embedded);
            }
            if (links != null) {
                links = links.rename(new NameTransformer(this){

                    public String transform(String name) {
                        return "_links";
                    }

                    public String reverse(String transformed) {
                        return transformed;
                    }
                });
                beanProperties.add(0, links);
            }
            return beanProperties;
        }
        return super.changeProperties(config, supplier, beanProperties);
    }
}

