/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.jackson.JacksonConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

@Singleton
public class OptionalValuesSerializer
extends ValueSerializer<OptionalValues<?>> {
    private final boolean alwaysSerializeErrorsAsList;

    public OptionalValuesSerializer() {
        this.alwaysSerializeErrorsAsList = false;
    }

    @Inject
    public OptionalValuesSerializer(JacksonConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    public boolean isEmpty(SerializationContext provider, OptionalValues<?> value) {
        return value.isEmpty();
    }

    public void serialize(OptionalValues<?> value, JsonGenerator gen, SerializationContext serializers) {
        gen.writeStartObject();
        for (CharSequence key : value) {
            Optional opt = value.get(key);
            if (!opt.isPresent()) continue;
            String fieldName = key.toString();
            gen.writeName(fieldName);
            Object v = opt.get();
            if (value instanceof OptionalMultiValues) {
                List list = (List)v;
                if (!(list.size() != 1 || list.get(0).getClass() == JsonError.class && this.alwaysSerializeErrorsAsList)) {
                    gen.writePOJO(list.get(0));
                    continue;
                }
                gen.writePOJO((Object)list);
                continue;
            }
            gen.writePOJO(v);
        }
        gen.writeEndObject();
    }
}

