/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.jackson.serialize.ConvertibleValuesDeserializer;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.type.TypeFactory;

@Internal
public class MicronautDeserializers
extends SimpleDeserializers {
    private final ConversionService conversionService;

    public MicronautDeserializers(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ValueDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription.Supplier supplier) throws DatabindException {
        if (type.getRawClass() == ConvertibleValues.class) {
            JavaType valueType = type.containedTypeOrUnknown(0);
            if (valueType.equals((Object)TypeFactory.unknownType())) {
                valueType = null;
            }
            return new ConvertibleValuesDeserializer(this.conversionService, valueType);
        }
        return super.findBeanDeserializer(type, config, supplier);
    }
}

