/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Singleton;
import java.io.IOException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

@Singleton
public final class JsonNodeSerializer
extends ValueSerializer<JsonNode> {
    public void serialize(JsonNode value, JsonGenerator gen, SerializationContext serializers) {
        if (value == null) {
            gen.writeNull();
        } else {
            try {
                JsonNodeTreeCodec.getInstance().writeTree(gen, value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

