/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.context.annotation.Bean;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.JacksonConfiguration;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;

@Singleton
@Bean(typed={JacksonObjectSerializer.class})
public class JacksonObjectSerializer
implements ObjectSerializer {
    private final ObjectMapper objectMapper;

    public JacksonObjectSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Optional<byte[]> serialize(Object object) throws SerializationException {
        try {
            return Optional.of(this.objectMapper.writeValueAsBytes(object));
        }
        catch (JacksonException e) {
            throw new SerializationException("Error serializing object to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public void serialize(Object object, OutputStream outputStream) throws SerializationException {
        try {
            this.objectMapper.writeValue(outputStream, object);
        }
        catch (JacksonException e) {
            throw new SerializationException("Error serializing object to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(byte[] bytes, Class<T> requiredType) throws SerializationException {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(bytes, requiredType));
        }
        catch (JacksonException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(InputStream inputStream, Class<T> requiredType) throws SerializationException {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(inputStream, requiredType));
        }
        catch (JacksonException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(byte[] bytes, Argument<T> requiredType) throws SerializationException {
        try {
            JavaType javaType = JacksonConfiguration.constructType(requiredType, this.objectMapper.getTypeFactory());
            return Optional.ofNullable(this.objectMapper.readValue(bytes, javaType));
        }
        catch (JacksonException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(InputStream inputStream, Argument<T> requiredType) throws SerializationException {
        try {
            JavaType javaType = JacksonConfiguration.constructType(requiredType, this.objectMapper.getTypeFactory());
            return Optional.ofNullable(this.objectMapper.readValue(inputStream, javaType));
        }
        catch (JacksonException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

