/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.convert.value.ConvertibleValues;
import jakarta.inject.Singleton;
import java.util.Map;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

@Singleton
public class ConvertibleValuesSerializer
extends ValueSerializer<ConvertibleValues<?>> {
    public boolean isEmpty(SerializationContext provider, ConvertibleValues<?> value) {
        return value.isEmpty();
    }

    public void serialize(ConvertibleValues<?> value, JsonGenerator gen, SerializationContext serializers) {
        gen.writeStartObject();
        for (Map.Entry entry : value) {
            String fieldName = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            gen.writeName(fieldName);
            serializers.defaultSerializeProperty(fieldName, v, gen);
        }
        gen.writeEndObject();
    }
}

