/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.jackson.serialize.JsonNodeDeserializer;
import io.micronaut.json.convert.JsonNodeConvertibleValues;
import io.micronaut.json.tree.JsonNode;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;

@Internal
final class ConvertibleValuesDeserializer<V>
extends ValueDeserializer<ConvertibleValues<V>> {
    private static final JsonNodeDeserializer JSON_NODE_DESERIALIZER = new JsonNodeDeserializer();
    private final ConversionService conversionService;
    private final @Nullable JavaType valueType;
    private final @Nullable ValueDeserializer<V> valueDeserializer;
    private final @Nullable TypeDeserializer typeDeserializer;

    ConvertibleValuesDeserializer(@NonNull ConversionService conversionService, @Nullable JavaType valueType) {
        this(conversionService, valueType, null, null);
    }

    private ConvertibleValuesDeserializer(@NonNull ConversionService conversionService, @Nullable JavaType valueType, @Nullable ValueDeserializer<V> valueDeserializer, @Nullable TypeDeserializer typeDeserializer) {
        this.conversionService = conversionService;
        this.valueType = valueType;
        this.valueDeserializer = valueDeserializer;
        this.typeDeserializer = typeDeserializer;
    }

    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws DatabindException {
        if (this.valueType == null) {
            return this;
        }
        ValueDeserializer valueDeserializer = ctxt.findContextualValueDeserializer(this.valueType, property);
        TypeDeserializer typeDeser = ctxt.findTypeDeserializer(this.valueType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return new ConvertibleValuesDeserializer<V>(this.conversionService, this.valueType, valueDeserializer, typeDeser);
    }

    public ConvertibleValues<V> deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this.valueDeserializer == null) {
            if (!p.hasCurrentToken()) {
                p.nextToken();
            }
            if (p.currentToken() != JsonToken.START_OBJECT) {
                return (ConvertibleValues)ctxt.handleUnexpectedToken(this.handledType(), p);
            }
            JsonNode node = JSON_NODE_DESERIALIZER.deserialize(p, ctxt);
            return new JsonNodeConvertibleValues(node, this.conversionService);
        }
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        if (t != JsonToken.PROPERTY_NAME && t != JsonToken.END_OBJECT) {
            return (ConvertibleValues)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        MutableConvertibleValuesMap map = new MutableConvertibleValuesMap();
        map.setConversionService(this.conversionService);
        while (p.currentToken() == JsonToken.PROPERTY_NAME) {
            String fieldName = p.currentName();
            p.nextToken();
            Object deserializedValue = this.typeDeserializer == null ? this.valueDeserializer.deserialize(p, ctxt) : this.valueDeserializer.deserializeWithType(p, ctxt, this.typeDeserializer);
            map.put((CharSequence)fieldName, deserializedValue);
            p.nextToken();
        }
        return map;
    }
}

