/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import io.micronaut.core.convert.value.ConvertibleMultiValues;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

@Singleton
public class ConvertibleMultiValuesSerializer
extends ValueSerializer<ConvertibleMultiValues<?>> {
    public boolean isEmpty(SerializationContext provider, ConvertibleMultiValues<?> value) {
        return value.isEmpty();
    }

    public void serialize(ConvertibleMultiValues<?> value, JsonGenerator gen, SerializationContext serializers) {
        gen.writeStartObject();
        for (Map.Entry entry : value) {
            String fieldName = (String)entry.getKey();
            List v = (List)entry.getValue();
            int len = v.size();
            if (len <= 0) continue;
            if (len == 1) {
                serializers.defaultSerializeProperty(fieldName, v.get(0), gen);
                continue;
            }
            gen.writeName(fieldName);
            gen.writeStartArray();
            for (Object o : v) {
                serializers.writeValue(gen, o);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

