/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@Internal
public class ObjectNodeConvertibleValues<V>
implements ConvertibleValues<V> {
    private final ObjectNode objectNode;
    private final ConversionService conversionService;

    public ObjectNodeConvertibleValues(ObjectNode objectNode, ConversionService conversionService) {
        this.objectNode = objectNode;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        Collection propertyNames = this.objectNode.propertyNames();
        return (Set)propertyNames;
    }

    public Collection<V> values() {
        ArrayList<JsonNode> values = new ArrayList<JsonNode>();
        for (JsonNode jsonNode : this.objectNode) {
            values.add(jsonNode);
        }
        return Collections.unmodifiableCollection(values);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String fieldName = name.toString();
        JsonNode jsonNode = this.objectNode.get(fieldName);
        if (jsonNode == null) {
            return Optional.empty();
        }
        return this.conversionService.convert((Object)jsonNode, conversionContext);
    }
}

