/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind.convert;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.databind.convert.ObjectNodeConvertibleValues;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ContainerNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.type.TypeFactory;

@Prototype
@Internal
public class JacksonConverterRegistrar
implements TypeConverterRegistrar {
    private final BeanProvider<ObjectMapper> objectMapper;
    private final ConversionService conversionService;

    @Inject
    public JacksonConverterRegistrar(BeanProvider<ObjectMapper> objectMapper, ConversionService conversionService) {
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(ArrayNode.class, Object[].class, this.arrayNodeToObjectConverter());
        conversionService.addConverter(ArrayNode.class, Iterable.class, this.arrayNodeToIterableConverter());
        conversionService.addConverter(JsonNode.class, Object.class, this.jsonNodeToObjectConverter());
        conversionService.addConverter(ObjectNode.class, ConvertibleValues.class, this.objectNodeToConvertibleValuesConverter());
        conversionService.addConverter(Object.class, JsonNode.class, this.objectToJsonNodeConverter());
        conversionService.addConverter(CharSequence.class, PropertyNamingStrategy.class, (charSequence, targetType, context) -> {
            Optional<PropertyNamingStrategy> propertyNamingStrategy = this.resolvePropertyNamingStrategy((CharSequence)charSequence);
            if (propertyNamingStrategy.isEmpty()) {
                context.reject(charSequence, (Exception)new IllegalArgumentException("Unable to convert '%s' to a com.fasterxml.jackson.databind.PropertyNamingStrategy".formatted(charSequence)));
            }
            return propertyNamingStrategy;
        });
    }

    protected TypeConverter<Object, JsonNode> objectToJsonNodeConverter() {
        return (object, targetType, context) -> {
            try {
                return Optional.of(((ObjectMapper)this.objectMapper.get()).valueToTree(object));
            }
            catch (IllegalArgumentException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    protected TypeConverter<ObjectNode, ConvertibleValues> objectNodeToConvertibleValuesConverter() {
        return (object, targetType, context) -> Optional.of(new ObjectNodeConvertibleValues((ObjectNode)object, this.conversionService));
    }

    protected TypeConverter<JsonNode, Object> jsonNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                Object result;
                if (CharSequence.class.isAssignableFrom(targetType) && node instanceof ObjectNode) {
                    return Optional.of(node.toString());
                }
                Argument argument = null;
                if (node instanceof ContainerNode && context instanceof ArgumentConversionContext) {
                    ArgumentConversionContext conversionContext = (ArgumentConversionContext)context;
                    if (targetType.getTypeParameters().length != 0) {
                        argument = conversionContext.getArgument();
                    }
                }
                if (argument != null) {
                    ObjectMapper om = (ObjectMapper)this.objectMapper.get();
                    JsonParser jsonParser = om.treeAsTokens((TreeNode)node);
                    TypeFactory typeFactory = om.getTypeFactory();
                    JavaType javaType = JacksonConfiguration.constructType(argument, typeFactory);
                    result = om.readValue(jsonParser, javaType);
                } else {
                    result = ((ObjectMapper)this.objectMapper.get()).treeToValue((TreeNode)node, targetType);
                }
                return Optional.ofNullable(result);
            }
            catch (JacksonException e) {
                context.reject((Exception)((Object)e));
                return Optional.empty();
            }
        };
    }

    protected TypeConverter<ArrayNode, Iterable> arrayNodeToIterableConverter() {
        return (node, targetType, context) -> {
            Map typeVariables = context.getTypeVariables();
            Class elementType = typeVariables.isEmpty() ? Map.class : ((Argument)typeVariables.values().iterator().next()).getType();
            ArrayList results = new ArrayList();
            node.elements().forEach(jsonNode -> {
                Optional converted = this.conversionService.convert(jsonNode, elementType, context);
                if (converted.isPresent()) {
                    results.add(converted.get());
                }
            });
            return Optional.of(results);
        };
    }

    protected TypeConverter<ArrayNode, Object[]> arrayNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                Object[] result = (Object[])((ObjectMapper)this.objectMapper.get()).treeToValue((TreeNode)node, targetType);
                return Optional.of(result);
            }
            catch (JacksonException e) {
                context.reject((Exception)((Object)e));
                return Optional.empty();
            }
        };
    }

    private @NonNull Optional<PropertyNamingStrategy> resolvePropertyNamingStrategy(@Nullable CharSequence charSequence) {
        String stringValue;
        if (charSequence != null && StringUtils.isNotEmpty((CharSequence)(stringValue = NameUtils.environmentName((String)charSequence.toString())))) {
            return switch (stringValue) {
                case "SNAKE_CASE" -> Optional.of(PropertyNamingStrategies.SNAKE_CASE);
                case "UPPER_CAMEL_CASE" -> Optional.of(PropertyNamingStrategies.UPPER_CAMEL_CASE);
                case "LOWER_CASE" -> Optional.of(PropertyNamingStrategies.LOWER_CASE);
                case "KEBAB_CASE" -> Optional.of(PropertyNamingStrategies.KEBAB_CASE);
                case "LOWER_CAMEL_CASE" -> Optional.of(PropertyNamingStrategies.LOWER_CAMEL_CASE);
                case "LOWER_DOT_CASE" -> Optional.of(PropertyNamingStrategies.LOWER_DOT_CASE);
                default -> Optional.empty();
            };
        }
        return Optional.empty();
    }
}

