/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.core.parser.JacksonCoreParserFactory;
import io.micronaut.jackson.core.parser.JacksonCoreProcessor;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.jackson.core.tree.TreeGenerator;
import io.micronaut.jackson.serialize.JsonNodeDeserializer;
import io.micronaut.jackson.serialize.JsonNodeSerializer;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.deser.DeserializationContextExt;

@Internal
@Singleton
@BootstrapContextCompatible
public final class JacksonDatabindMapper
implements JsonMapper {
    public static final String PROPERTY_JSON_VIEW_ENABLED = "jackson.json-view.enabled";
    private final ObjectMapper objectMapper;
    private final JsonStreamConfig config;
    private final JsonNodeTreeCodec treeCodec;
    private final ObjectReader specializedReader;
    private final ObjectWriter specializedWriter;
    private final boolean allowViews;
    private TypeCache<ObjectReader> cachedReader;
    private TypeCache<ObjectWriter> cachedWriter;

    @Internal
    public JacksonDatabindMapper(ObjectMapper objectMapper) {
        this(objectMapper, false);
    }

    @Inject
    @Internal
    public JacksonDatabindMapper(ObjectMapper objectMapper, @Value(value="${jackson.json-view.enabled:false}") boolean allowViews) {
        this.objectMapper = objectMapper;
        this.allowViews = allowViews;
        this.config = JsonStreamConfig.DEFAULT.withUseBigDecimalForFloats(objectMapper.deserializationConfig().isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)).withUseBigIntegerForInts(objectMapper.deserializationConfig().isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS));
        this.treeCodec = JsonNodeTreeCodec.getInstance().withConfig(this.config);
        this.specializedReader = null;
        this.specializedWriter = null;
    }

    @Internal
    public JacksonDatabindMapper() {
        this(JacksonDatabindMapper.createDefaultMapper(), false);
    }

    private JacksonDatabindMapper(JacksonDatabindMapper from, Argument<?> type, boolean allowViews) {
        this.objectMapper = from.objectMapper;
        this.config = from.config;
        this.treeCodec = from.treeCodec;
        this.specializedReader = from.createReader(type);
        this.specializedWriter = from.createWriter(type);
        this.allowViews = allowViews;
    }

    private JacksonDatabindMapper(JacksonDatabindMapper from, ObjectReader reader, ObjectWriter writer) {
        this.objectMapper = from.objectMapper;
        this.config = from.config;
        this.treeCodec = from.treeCodec;
        this.specializedReader = reader;
        this.specializedWriter = writer;
        this.allowViews = from.allowViews;
    }

    private static ObjectMapper createDefaultMapper() {
        ObjectMapperFactory objectMapperFactory = new ObjectMapperFactory();
        objectMapperFactory.setDeserializers(new JsonNodeDeserializer());
        objectMapperFactory.setSerializers(new JsonNodeSerializer());
        return objectMapperFactory.jsonMapperBuilder(null, null).build();
    }

    @Internal
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public @NonNull JsonMapper createSpecific(@NonNull Argument<?> type) {
        Class viewClass;
        JacksonDatabindMapper jacksonDatabindMapper = new JacksonDatabindMapper(this, type, this.allowViews);
        if (this.allowViews && (viewClass = (Class)type.getAnnotationMetadata().classValue(JsonView.class).orElse(null)) != null) {
            return jacksonDatabindMapper.cloneWithViewClass(viewClass);
        }
        return jacksonDatabindMapper;
    }

    private ObjectReader createReader(@NonNull Argument<?> type) {
        if (this.specializedReader != null) {
            return this.specializedReader;
        }
        TypeCache<ObjectReader> cachedReader = this.cachedReader;
        if (cachedReader != null && cachedReader.type == type) {
            return (ObjectReader)cachedReader.cachedValue;
        }
        ObjectReader reader = this.objectMapper.readerFor(JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
        Optional view = type.getAnnotationMetadata().classValue(JsonView.class);
        if (view.isPresent()) {
            reader = reader.withView((Class)view.get());
        }
        this.cachedReader = new TypeCache<ObjectReader>(type, reader);
        return reader;
    }

    private ObjectWriter createWriter(@NonNull Argument<?> type) {
        if (this.specializedWriter != null) {
            return this.specializedWriter;
        }
        TypeCache<ObjectWriter> cachedWriter = this.cachedWriter;
        if (cachedWriter != null && cachedWriter.type == type) {
            return (ObjectWriter)cachedWriter.cachedValue;
        }
        ObjectWriter writer = this.objectMapper.writerFor(JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
        Optional view = type.getAnnotationMetadata().classValue(JsonView.class);
        if (view.isPresent()) {
            writer = writer.withView((Class)view.get());
        }
        this.cachedWriter = new TypeCache<ObjectWriter>(type, writer);
        return writer;
    }

    public <T> T readValueFromTree(@NonNull JsonNode tree, @NonNull Argument<T> type) throws IOException {
        return (T)this.createReader(type).readValue(this.treeAsTokens(tree));
    }

    public @NonNull JsonNode writeValueToTree(@Nullable Object value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        this.objectMapper.writeValue((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    public <T> @NonNull JsonNode writeValueToTree(@NonNull Argument<T> type, T value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        this.createWriter(type).writeValue((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    public <T> T readValue(@NonNull InputStream inputStream, @NonNull Argument<T> type) throws IOException {
        try {
            return (T)this.createReader(type).readValue(inputStream);
        }
        catch (StreamReadException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public <T> T readValue(byte @NonNull [] byteArray, @NonNull Argument<T> type) throws IOException {
        try {
            return (T)this.createReader(type).readValue(byteArray);
        }
        catch (StreamReadException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readValue(@NonNull ByteBuffer<?> byteBuffer, @NonNull Argument<T> type) throws IOException {
        try (JsonParser parser = JacksonCoreParserFactory.createJsonParser((JsonFactory)((JsonFactory)this.objectMapper.tokenStreamFactory()), (ObjectReadContext)this.objectMapper._deserializationContext(), byteBuffer);){
            Object object = this.createReader(type).readValue(parser);
            return (T)object;
        }
        catch (StreamReadException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public <T> T readValue(@NonNull ReadBuffer readBuffer, @NonNull Argument<T> type) throws IOException {
        try {
            ObjectReader reader = this.createReader(type);
            Optional direct = (Optional)readBuffer.useFastHeapBuffer(bb -> Optional.ofNullable(reader.readValue(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining())));
            if (direct != null) {
                return direct.orElse(null);
            }
            return (T)reader.readValue(readBuffer.toInputStream());
        }
        catch (StreamReadException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public void writeValue(@NonNull OutputStream outputStream, @Nullable Object object) throws IOException {
        if (this.specializedWriter != null) {
            this.specializedWriter.writeValue(outputStream, object);
        } else {
            this.objectMapper.writeValue(outputStream, object);
        }
    }

    public <T> void writeValue(@NonNull OutputStream outputStream, @NonNull Argument<T> type, T object) throws IOException {
        this.createWriter(type).writeValue(outputStream, object);
    }

    public byte[] writeValueAsBytes(@Nullable Object object) throws IOException {
        if (this.specializedWriter != null) {
            return this.specializedWriter.writeValueAsBytes(object);
        }
        return this.objectMapper.writeValueAsBytes(object);
    }

    public <T> byte[] writeValueAsBytes(@NonNull Argument<T> type, T object) throws IOException {
        return this.createWriter(type).writeValueAsBytes(object);
    }

    public void updateValueFromTree(Object value, @NonNull JsonNode tree) throws IOException {
        this.objectMapper.readerForUpdating(value).readValue(this.treeAsTokens(tree));
    }

    public @NonNull JsonMapper cloneWithFeatures(@NonNull JsonFeatures features) {
        JacksonFeatures jacksonFeatures = (JacksonFeatures)features;
        MapperBuilder builder = this.objectMapper.rebuild();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((MapperBuilder)builder).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((MapperBuilder)builder).configure(arg_0, arg_1));
        for (Class<? extends JacksonModule> moduleClass : jacksonFeatures.getAdditionalModules()) {
            builder.addModule((JacksonModule)InstantiationUtils.instantiate(moduleClass));
        }
        return new JacksonDatabindMapper(builder.build(), this.allowViews);
    }

    public @NonNull JsonMapper cloneWithViewClass(@NonNull Class<?> viewClass) {
        ObjectReader reader = this.objectMapper.readerWithView(viewClass);
        ObjectWriter writer = this.objectMapper.writerWithView(viewClass);
        return new JacksonDatabindMapper(this, reader, writer);
    }

    public @NonNull JsonStreamConfig getStreamConfig() {
        return this.config;
    }

    public @NonNull Processor<byte[], JsonNode> createReactiveParser(final @NonNull Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new JacksonCoreProcessor(this, streamArray, this.objectMapper.tokenStreamFactory(), this.config){

            public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                onSubscribe.accept(this);
                super.subscribe(downstreamSubscriber);
            }
        };
    }

    public @NonNull Optional<JsonFeatures> detectFeatures(@NonNull AnnotationMetadata annotations) {
        return Optional.ofNullable(annotations.getAnnotation(io.micronaut.jackson.annotation.JacksonFeatures.class)).map(JacksonFeatures::fromAnnotation);
    }

    private JsonParser treeAsTokens(@NonNull JsonNode tree) {
        DeserializationContextExt context = this.objectMapper._deserializationContext();
        return this.treeCodec.treeAsTokens(tree, (ObjectReadContext)context);
    }

    private record TypeCache<T>(Argument<?> type, T cachedValue) {
    }
}

