/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind;

import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.json.bind.JsonBeanPropertyBinderExceptionHandler;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.exc.InvalidFormatException;

@Singleton
final class DatabindPropertyBinderExceptionHandler
implements JsonBeanPropertyBinderExceptionHandler {
    DatabindPropertyBinderExceptionHandler() {
    }

    public Optional<ConversionErrorException> toConversionError(@Nullable Object object, final @NonNull Exception e) {
        if (e instanceof InvalidFormatException) {
            InvalidFormatException ife = (InvalidFormatException)e;
            final Object originalValue = ife.getValue();
            ConversionError conversionError = new ConversionError(){

                public Exception getCause() {
                    return e;
                }

                public Optional<Object> getOriginalValue() {
                    return Optional.ofNullable(originalValue);
                }
            };
            Class type = object != null ? object.getClass() : Object.class;
            List path = ife.getPath();
            String name = !path.isEmpty() ? ((JacksonException.Reference)path.get(path.size() - 1)).getPropertyName() : NameUtils.decapitalize((String)type.getSimpleName());
            return Optional.of(new ConversionErrorException(Argument.of((Class)ife.getTargetType(), (String)name), conversionError));
        }
        return Optional.empty();
    }
}

