/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.codec.JacksonMediaTypeCodec;
import io.micronaut.jackson.databind.JacksonDatabindMapper;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;

@Named(value="json")
@Singleton
@Secondary
@BootstrapContextCompatible
@Bean(typed={JsonMediaTypeCodec.class, JacksonMediaTypeCodec.class})
@Deprecated(forRemoval=true, since="4.7")
public class JsonMediaTypeCodec
extends JacksonMediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "json";

    public JsonMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, codecConfiguration, MediaType.APPLICATION_JSON_TYPE);
    }

    @Deprecated
    public JsonMediaTypeCodec(BeanProvider<ObjectMapper> objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, codecConfiguration, MediaType.APPLICATION_JSON_TYPE);
    }

    @Inject
    public JsonMediaTypeCodec(BeanProvider<JacksonDatabindMapper> jacksonDatabindMappers, @Named(value="json") @Nullable CodecConfiguration codecConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(jacksonDatabindMappers, applicationConfiguration, MediaType.APPLICATION_JSON_TYPE, codecConfiguration);
    }

    @Override
    public JacksonMediaTypeCodec cloneWithFeatures(JacksonFeatures jacksonFeatures) {
        MapperBuilder builder = this.getObjectMapper().rebuild();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((MapperBuilder)builder).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((MapperBuilder)builder).configure(arg_0, arg_1));
        return new JsonMediaTypeCodec(builder.build(), this.applicationConfiguration, this.codecConfiguration);
    }
}

