/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.databind.JacksonDatabindMapper;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.TypeFactory;

@Deprecated(forRemoval=true, since="4.7")
public abstract class JacksonMediaTypeCodec
extends MapperMediaTypeCodec {
    public static final String REGULAR_JSON_MEDIA_TYPE_CODEC_NAME = "json";

    public JacksonMediaTypeCodec(BeanProvider<ObjectMapper> objectMapperProvider, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        super((JsonMapper)new JacksonDatabindMapper((ObjectMapper)objectMapperProvider.get()), applicationConfiguration, codecConfiguration, mediaType);
    }

    public JacksonMediaTypeCodec(BeanProvider<JacksonDatabindMapper> objectMapperProvider, ApplicationConfiguration applicationConfiguration, MediaType mediaType, CodecConfiguration codecConfiguration) {
        super((JsonMapper)objectMapperProvider.get(), applicationConfiguration, codecConfiguration, mediaType);
    }

    public JacksonMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        super((JsonMapper)new JacksonDatabindMapper(objectMapper), applicationConfiguration, codecConfiguration, mediaType);
    }

    public ObjectMapper getObjectMapper() {
        return ((JacksonDatabindMapper)this.getJsonMapper()).getObjectMapper();
    }

    public MapperMediaTypeCodec cloneWithFeatures(JsonFeatures features) {
        return this.cloneWithFeatures((JacksonFeatures)features);
    }

    public abstract JacksonMediaTypeCodec cloneWithFeatures(JacksonFeatures var1);

    protected MapperMediaTypeCodec cloneWithMapper(JsonMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> T decode(Argument<T> type, JsonNode node) throws CodecException {
        try {
            ObjectMapper objectMapper = this.getObjectMapper();
            if (type.hasTypeVariables()) {
                JsonParser jsonParser = objectMapper.treeAsTokens((TreeNode)node);
                return (T)objectMapper.readValue(jsonParser, this.constructJavaType(type));
            }
            return (T)objectMapper.treeToValue((TreeNode)node, type.getType());
        }
        catch (JacksonException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> JavaType constructJavaType(Argument<T> type) {
        TypeFactory typeFactory = this.getObjectMapper().getTypeFactory();
        return JacksonConfiguration.constructType(type, typeFactory);
    }
}

