/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.json.JsonFeatures;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.SerializationFeature;

@Internal
public final class JacksonFeatures
implements JsonFeatures {
    private final Map<SerializationFeature, Boolean> serializationFeatures = new EnumMap<SerializationFeature, Boolean>(SerializationFeature.class);
    private final Map<DeserializationFeature, Boolean> deserializationFeatures = new EnumMap<DeserializationFeature, Boolean>(DeserializationFeature.class);
    private final List<Class<? extends JacksonModule>> additionalModules = new ArrayList<Class<? extends JacksonModule>>();

    public static JacksonFeatures fromAnnotation(AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn) {
        Object[] additionalModules;
        Object[] disabledDeserializationFeatures;
        Object[] disabledSerializationFeatures;
        Object[] enabledDeserializationFeatures;
        JacksonFeatures jacksonFeatures = new JacksonFeatures();
        Object[] enabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.enumValues("enabledSerializationFeatures", SerializationFeature.class);
        if (ArrayUtils.isNotEmpty((Object[])enabledSerializationFeatures)) {
            for (Object serializationFeature : enabledSerializationFeatures) {
                jacksonFeatures.addFeature((SerializationFeature)serializationFeature, true);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.enumValues("enabledDeserializationFeatures", DeserializationFeature.class)))) {
            for (Object deserializationFeature : enabledDeserializationFeatures) {
                jacksonFeatures.addFeature((DeserializationFeature)deserializationFeature, true);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(disabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.enumValues("disabledSerializationFeatures", SerializationFeature.class)))) {
            for (Object serializationFeature : disabledSerializationFeatures) {
                jacksonFeatures.addFeature((SerializationFeature)serializationFeature, false);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.enumValues("disabledDeserializationFeatures", DeserializationFeature.class)))) {
            for (Object feature : disabledDeserializationFeatures) {
                jacksonFeatures.addFeature((DeserializationFeature)feature, false);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(additionalModules = jacksonFeaturesAnn.classValues("additionalModules")))) {
            for (Object additionalModule : additionalModules) {
                jacksonFeatures.addModule((Class<? extends JacksonModule>)additionalModule);
            }
        }
        return jacksonFeatures;
    }

    public JacksonFeatures addFeature(SerializationFeature serializationFeature, boolean isEnabled) {
        this.serializationFeatures.put(serializationFeature, isEnabled);
        return this;
    }

    public JacksonFeatures addFeature(DeserializationFeature deserializationFeature, boolean isEnabled) {
        this.deserializationFeatures.put(deserializationFeature, isEnabled);
        return this;
    }

    public @NonNull JacksonFeatures addModule(@NonNull Class<? extends JacksonModule> moduleClass) {
        Objects.requireNonNull(moduleClass, "moduleClass");
        this.additionalModules.add(moduleClass);
        return this;
    }

    public Map<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public Map<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }

    public @NonNull List<Class<? extends JacksonModule>> getAdditionalModules() {
        return this.additionalModules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonFeatures that = (JacksonFeatures)o;
        return Objects.equals(this.serializationFeatures, that.serializationFeatures) && Objects.equals(this.deserializationFeatures, that.deserializationFeatures);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.serializationFeatures, this.deserializationFeatures);
    }
}

