/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.serialize.MicronautDeserializers;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.core.json.JsonFactoryBuilder;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.jdk.StringDeserializer;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.DefaultBaseTypeLimitingValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.ValueSerializerModifier;

@Factory
@BootstrapContextCompatible
public class ObjectMapperFactory {
    public static final String MICRONAUT_MODULE = "micronaut";
    @Inject
    protected ConversionService conversionService;
    @Inject
    protected BeanContext beanContext;
    @Inject
    protected JacksonModule[] jacksonModules = new JacksonModule[0];
    @Inject
    protected ValueSerializer[] serializers = new ValueSerializer[0];
    @Inject
    protected ValueDeserializer[] deserializers = new ValueDeserializer[0];
    @Inject
    protected ValueSerializerModifier[] beanSerializerModifiers = new ValueSerializerModifier[0];
    @Inject
    protected ValueDeserializerModifier[] beanDeserializerModifiers = new ValueDeserializerModifier[0];
    @Inject
    protected KeyDeserializer[] keyDeserializers = new KeyDeserializer[0];

    @Requires(beans={JacksonConfiguration.class})
    @Singleton
    @BootstrapContextCompatible
    public JsonFactory jsonFactory(JacksonConfiguration jacksonConfiguration) {
        JsonFactoryBuilder jsonFactoryBuilder = JsonFactory.builder();
        jacksonConfiguration.getJsonFactoryFeatures().forEach((arg_0, arg_1) -> ((JsonFactoryBuilder)jsonFactoryBuilder).configure(arg_0, arg_1));
        return jsonFactoryBuilder.build();
    }

    public void setSerializers(ValueSerializer ... serializers) {
        this.serializers = serializers;
    }

    public void setDeserializers(ValueDeserializer ... deserializers) {
        this.deserializers = deserializers;
    }

    @Singleton
    @Primary
    @Named(value="json")
    @BootstrapContextCompatible
    public JsonMapper jsonMapper(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull JsonMapper.Builder jsonMapperBuilder) {
        return jsonMapperBuilder.build();
    }

    @BootstrapContextCompatible
    @Prototype
    public JsonMapper.Builder jsonMapperBuilder(@Nullable JacksonConfiguration jacksonConfiguration, @Nullable JsonFactory jsonFactory) {
        Optional targetType;
        Class[] value;
        Type annotation;
        Class<?> type;
        boolean hasConfiguration;
        JsonMapper.Builder builder = jsonFactory != null ? JsonMapper.builder((JsonFactory)jsonFactory) : JsonMapper.builder();
        boolean bl = hasConfiguration = jacksonConfiguration != null;
        if (!hasConfiguration || jacksonConfiguration.isModuleScan()) {
            builder.findAndAddModules();
        }
        builder.addModules(this.jacksonModules);
        if (this.beanContext != null) {
            builder.typeFactory(builder.typeFactory().withClassLoader(this.beanContext.getClassLoader()));
        }
        SimpleModule module = new SimpleModule(MICRONAUT_MODULE);
        module.setDeserializers((SimpleDeserializers)new MicronautDeserializers(this.conversionService));
        for (ValueSerializer valueSerializer : this.serializers) {
            type = valueSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addSerializer(aClass, valueSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            if (targetType.isPresent()) {
                module.addSerializer((Class)targetType.get(), valueSerializer);
                continue;
            }
            module.addSerializer(valueSerializer);
        }
        for (ValueSerializer valueSerializer : this.deserializers) {
            type = valueSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addDeserializer(aClass, (ValueDeserializer)valueSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            targetType.ifPresent(arg_0 -> ObjectMapperFactory.lambda$jsonMapperBuilder$0(module, (ValueDeserializer)valueSerializer, arg_0));
        }
        if (hasConfiguration && jacksonConfiguration.isTrimStrings()) {
            module.addDeserializer(String.class, (ValueDeserializer)new StringDeserializer(this){

                public String deserialize(JsonParser p, DeserializationContext ctxt) {
                    String value = super.deserialize(p, ctxt);
                    return StringUtils.trimToNull((String)value);
                }
            });
        }
        for (ValueSerializer valueSerializer : this.keyDeserializers) {
            type = valueSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation == null) continue;
            for (Class clazz : value = annotation.value()) {
                module.addKeyDeserializer(clazz, (KeyDeserializer)valueSerializer);
            }
        }
        builder.addModule((JacksonModule)module);
        for (ValueSerializer valueSerializer : this.beanSerializerModifiers) {
            builder.serializerFactory(builder.serializerFactory().withSerializerModifier((ValueSerializerModifier)valueSerializer));
        }
        ((JsonMapper.Builder)((JsonMapper.Builder)builder.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true)).configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        if (hasConfiguration) {
            PropertyNamingStrategy propertyNamingStrategy;
            TimeZone timeZone;
            Locale locale;
            String dateFormat;
            JsonInclude.Include include;
            DefaultTyping defaultTyping = jacksonConfiguration.getDefaultTyping();
            if (defaultTyping != null) {
                builder.activateDefaultTyping((PolymorphicTypeValidator)new DefaultBaseTypeLimitingValidator(), defaultTyping);
            }
            if ((include = jacksonConfiguration.getSerializationInclusion()) != null) {
                builder.changeDefaultPropertyInclusion(oldInclude -> oldInclude.withValueInclusion(include).withContentInclusion(include));
            }
            if ((dateFormat = jacksonConfiguration.getDateFormat()) != null) {
                builder.defaultDateFormat((DateFormat)new SimpleDateFormat(dateFormat));
            }
            if ((locale = jacksonConfiguration.getLocale()) != null) {
                builder.defaultLocale(locale);
            }
            if ((timeZone = jacksonConfiguration.getTimeZone()) != null) {
                builder.defaultTimeZone(timeZone);
            }
            if ((propertyNamingStrategy = jacksonConfiguration.getPropertyNamingStrategy()) != null) {
                builder.propertyNamingStrategy(propertyNamingStrategy);
            }
            jacksonConfiguration.getStreamReadFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getStreamWriteFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getMapperFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getJsonReadFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getJsonWriteFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getDateTimeFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getEnumFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getJsonNodeFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            jacksonConfiguration.getSerializationFeatures().forEach((arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
        }
        return builder;
    }

    private static /* synthetic */ void lambda$jsonMapperBuilder$0(SimpleModule module, ValueDeserializer deserializer, Class aClass) {
        module.addDeserializer(aClass, deserializer);
    }
}

