/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.JsonConfiguration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jspecify.annotations.NonNull;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.cfg.JsonNodeFeature;
import tools.jackson.databind.type.TypeFactory;

@ConfigurationProperties(value="jackson")
@TypeHint(value={PropertyNamingStrategies.UpperCamelCaseStrategy.class, ArrayList.class, LinkedHashMap.class, HashSet.class})
public class JacksonConfiguration
implements JsonConfiguration {
    public static final int DEFAULT_ARRAYSIZETHRESHOLD = 100;
    public static final String PROPERTY_MODULE_SCAN = "jackson.module-scan";
    private boolean moduleScan = true;
    private String dateFormat;
    private Locale locale;
    private TimeZone timeZone;
    private int arraySizeThreshold = 100;
    private Map<SerializationFeature, Boolean> serializationFeatures = Collections.emptyMap();
    private Map<DeserializationFeature, Boolean> deserializationFeatures = Collections.emptyMap();
    private Map<MapperFeature, Boolean> mapperFeatures = Collections.emptyMap();
    private Map<JsonReadFeature, Boolean> jsonReadFeatures = Collections.emptyMap();
    private Map<JsonWriteFeature, Boolean> jsonWriteFeatures = Collections.emptyMap();
    private Map<TokenStreamFactory.Feature, Boolean> jsonFactoryFeatures = Collections.emptyMap();
    private Map<StreamReadFeature, Boolean> streamReadFeatures = Collections.emptyMap();
    private Map<StreamWriteFeature, Boolean> streamWriteFeatures = Collections.emptyMap();
    private Map<EnumFeature, Boolean> enumFeatures = Collections.emptyMap();
    private Map<DateTimeFeature, Boolean> dateTimeFeatures = Collections.emptyMap();
    private Map<JsonNodeFeature, Boolean> jsonNodeFeatures = Collections.emptyMap();
    private JsonInclude.Include serializationInclusion = JsonInclude.Include.NON_EMPTY;
    private DefaultTyping defaultTyping = null;
    private PropertyNamingStrategy propertyNamingStrategy = null;
    private boolean alwaysSerializeErrorsAsList = true;
    private boolean trimStrings = false;

    public boolean isModuleScan() {
        return this.moduleScan;
    }

    public void setModuleScan(boolean moduleScan) {
        this.moduleScan = moduleScan;
    }

    public JsonInclude.Include getSerializationInclusion() {
        return this.serializationInclusion;
    }

    public DefaultTyping getDefaultTyping() {
        return this.defaultTyping;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public int getArraySizeThreshold() {
        return this.arraySizeThreshold;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public boolean isAlwaysSerializeErrorsAsList() {
        return this.alwaysSerializeErrorsAsList;
    }

    public boolean isTrimStrings() {
        return this.trimStrings;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setArraySizeThreshold(int arraySizeThreshold) {
        this.arraySizeThreshold = arraySizeThreshold;
    }

    public void setSerializationFeatures(Map<SerializationFeature, Boolean> serializationFeatures) {
        if (CollectionUtils.isNotEmpty(serializationFeatures)) {
            this.serializationFeatures = serializationFeatures;
        }
    }

    public void setDeserializationFeatures(Map<DeserializationFeature, Boolean> deserializationFeatures) {
        if (CollectionUtils.isNotEmpty(deserializationFeatures)) {
            this.deserializationFeatures = deserializationFeatures;
        }
    }

    public void setMapperFeatures(Map<MapperFeature, Boolean> mapperFeatures) {
        if (CollectionUtils.isNotEmpty(mapperFeatures)) {
            this.mapperFeatures = mapperFeatures;
        }
    }

    public Map<StreamWriteFeature, Boolean> getStreamWriteFeatures() {
        return this.streamWriteFeatures;
    }

    public void setStreamWriteFeatures(Map<StreamWriteFeature, Boolean> streamWriteFeatures) {
        this.streamWriteFeatures = streamWriteFeatures;
    }

    public Map<StreamReadFeature, Boolean> getStreamReadFeatures() {
        return this.streamReadFeatures;
    }

    public void setStreamReadFeatures(Map<StreamReadFeature, Boolean> streamReadFeatures) {
        this.streamReadFeatures = streamReadFeatures;
    }

    public Map<TokenStreamFactory.Feature, Boolean> getJsonFactoryFeatures() {
        return this.jsonFactoryFeatures;
    }

    public void setJsonFactoryFeatures(Map<TokenStreamFactory.Feature, Boolean> jsonFactoryFeatures) {
        this.jsonFactoryFeatures = jsonFactoryFeatures;
    }

    public Map<JsonWriteFeature, Boolean> getJsonWriteFeatures() {
        return this.jsonWriteFeatures;
    }

    public void setJsonWriteFeatures(Map<JsonWriteFeature, Boolean> jsonWriteFeatures) {
        this.jsonWriteFeatures = jsonWriteFeatures;
    }

    public Map<JsonReadFeature, Boolean> getJsonReadFeatures() {
        return this.jsonReadFeatures;
    }

    public void setJsonReadFeatures(Map<JsonReadFeature, Boolean> jsonReadFeatures) {
        this.jsonReadFeatures = jsonReadFeatures;
    }

    public Map<MapperFeature, Boolean> getMapperFeatures() {
        return this.mapperFeatures;
    }

    public Map<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }

    public Map<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public Map<EnumFeature, Boolean> getEnumFeatures() {
        return this.enumFeatures;
    }

    public void setEnumFeatures(Map<EnumFeature, Boolean> enumFeatures) {
        this.enumFeatures = enumFeatures;
    }

    public Map<DateTimeFeature, Boolean> getDateTimeFeatures() {
        return this.dateTimeFeatures;
    }

    public void setDateTimeFeatures(Map<DateTimeFeature, Boolean> dateTimeFeatures) {
        this.dateTimeFeatures = dateTimeFeatures;
    }

    public Map<JsonNodeFeature, Boolean> getJsonNodeFeatures() {
        return this.jsonNodeFeatures;
    }

    public void setJsonNodeFeatures(Map<JsonNodeFeature, Boolean> jsonNodeFeatures) {
        this.jsonNodeFeatures = jsonNodeFeatures;
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        if (serializationInclusion != null) {
            this.serializationInclusion = serializationInclusion;
        }
    }

    public void setDefaultTyping(DefaultTyping defaultTyping) {
        this.defaultTyping = defaultTyping;
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
    }

    public void setAlwaysSerializeErrorsAsList(boolean alwaysSerializeErrorsAsList) {
        this.alwaysSerializeErrorsAsList = alwaysSerializeErrorsAsList;
    }

    public void setTrimStrings(boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    public static <T> JavaType constructType(@NonNull Argument<T> type, @NonNull TypeFactory typeFactory) {
        ArgumentUtils.requireNonNull((String)"type", type);
        ArgumentUtils.requireNonNull((String)"typeFactory", (Object)typeFactory);
        Map typeVariables = type.getTypeVariables();
        Object[] objects = JacksonConfiguration.toJavaTypeArray(typeFactory, typeVariables);
        Class rawType = type.getType();
        if (ArrayUtils.isNotEmpty((Object[])objects)) {
            JavaType javaType = typeFactory.constructType((Type)rawType);
            if (javaType.isCollectionLikeType()) {
                return typeFactory.constructCollectionLikeType(rawType, (JavaType)objects[0]);
            }
            if (javaType.isMapLikeType()) {
                return typeFactory.constructMapLikeType(rawType, (JavaType)objects[0], (JavaType)objects[1]);
            }
            if (javaType.isReferenceType()) {
                return typeFactory.constructReferenceType(rawType, (JavaType)objects[0]);
            }
            return typeFactory.constructParametricType(rawType, (JavaType[])objects);
        }
        return typeFactory.constructType((Type)rawType);
    }

    private static JavaType[] toJavaTypeArray(TypeFactory typeFactory, Map<String, Argument<?>> typeVariables) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (Argument<?> argument : typeVariables.values()) {
            if (argument.hasTypeVariables()) {
                javaTypes.add(typeFactory.constructParametricType(argument.getType(), JacksonConfiguration.toJavaTypeArray(typeFactory, argument.getTypeVariables())));
                continue;
            }
            javaTypes.add(typeFactory.constructType((Type)argument.getType()));
        }
        return javaTypes.toArray(new JavaType[0]);
    }
}

