/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.expressions.EvaluatedExpression;
import io.micronaut.core.expressions.ExpressionEvaluationContext;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
final class EvaluatedConvertibleValuesMap<V>
implements ConvertibleValues<V> {
    private final ExpressionEvaluationContext evaluationContext;
    private final ConvertibleValues<V> delegateValues;

    EvaluatedConvertibleValuesMap(ExpressionEvaluationContext evaluationContext, ConvertibleValues<V> delegateValues) {
        this.evaluationContext = evaluationContext;
        this.delegateValues = delegateValues;
    }

    public Set<String> names() {
        return this.delegateValues.names();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.delegateValues.getValue(name);
        if (value instanceof EvaluatedExpression) {
            EvaluatedExpression expression = (EvaluatedExpression)value;
            if (EvaluatedExpression.class.isAssignableFrom(conversionContext.getArgument().getClass())) {
                return Optional.of(value);
            }
            Object evaluationResult = expression.evaluate(this.evaluationContext);
            if (evaluationResult == null || conversionContext.getArgument().isAssignableFrom(evaluationResult.getClass())) {
                return Optional.ofNullable(evaluationResult);
            }
            return ConversionService.SHARED.convert(evaluationResult, conversionContext);
        }
        return this.delegateValues.get(name, conversionContext);
    }

    public Collection<V> values() {
        return this.delegateValues.values().stream().map(v -> {
            if (v instanceof EvaluatedExpression) {
                EvaluatedExpression expression = (EvaluatedExpression)v;
                Object evaluationResult = expression.evaluate(this.evaluationContext);
                return evaluationResult;
            }
            return v;
        }).collect(Collectors.toList());
    }
}

