/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.annotation.Primary;
import io.micronaut.inject.BeanType;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public interface Qualifier<T> {
    public static final String PRIMARY = Primary.class.getName();

    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> var1, Stream<BT> var2);

    default public boolean contains(Qualifier<T> qualifier) {
        return this.equals(qualifier);
    }

    default public <BT extends BeanType<T>> Optional<BT> qualify(Class<T> beanType, Stream<BT> candidates) {
        return this.reduce(beanType, candidates).findFirst();
    }

    default public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        return this.reduce(beanType, Stream.of(candidate)).findAny().isPresent();
    }

    default public boolean doesQualify(Class<T> beanType, Collection<? extends BeanType<T>> candidates) {
        return this.reduce(beanType, candidates.stream()).findAny().isPresent();
    }

    default public <BT extends BeanType<T>> Collection<BT> filter(Class<T> beanType, Collection<BT> candidates) {
        return this.reduce(beanType, candidates.stream()).toList();
    }
}

