/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanResolutionTracer;
import io.micronaut.context.ConsoleBeanResolutionTracer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BeanResolutionTraceMode {
    NONE(null),
    LOG(new ConsoleBeanResolutionTracer.LoggingBeanResolutionTracer()),
    STANDARD_OUT(new ConsoleBeanResolutionTracer.SystemOutBeanResolutionTracer());

    static final Logger LOGGER;
    private static final String MODE_SYS_PROP = "micronaut.inject.trace.mode";
    private static final String MODE_ENV_VAR = "MICRONAUT_INJECT_TRACE_MODE";
    private static final String CLASSES_SYS_PROP = "micronaut.inject.trace";
    private static final String CLASSES_ENV_VAR = "MICRONAUT_INJECT_TRACE";
    private final BeanResolutionTracer resolutionTracer;

    private BeanResolutionTraceMode(BeanResolutionTracer resolutionTracer) {
        this.resolutionTracer = resolutionTracer;
    }

    Optional<BeanResolutionTracer> getTracer() {
        return Optional.ofNullable(this.resolutionTracer);
    }

    @Internal
    static BeanResolutionTraceMode getDefaultMode(Set<String> traceClasses) {
        String mode = Optional.ofNullable(System.getProperty(MODE_SYS_PROP)).orElseGet(() -> System.getenv(MODE_ENV_VAR));
        if (mode != null) {
            return BeanResolutionTraceMode.valueOf(NameUtils.environmentName((String)mode));
        }
        if (traceClasses.isEmpty()) {
            return LOGGER.isTraceEnabled() ? LOG : NONE;
        }
        return LOGGER.isTraceEnabled() ? LOG : STANDARD_OUT;
    }

    @Internal
    @NonNull
    static Set<String> getDefaultTraceClasses() {
        String classes = Optional.ofNullable(System.getProperty(CLASSES_SYS_PROP)).orElseGet(() -> System.getenv(CLASSES_ENV_VAR));
        if (classes != null) {
            return Set.of(classes.split(","));
        }
        return Set.of();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"io.micronaut.inject");
    }
}

