/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.AbstractInitializableBeanDefinition;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultConditionContext;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.conditions.MatchesDynamicCondition;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.ExecutableMethodsDefinition;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import java.util.Map;

public abstract class AbstractInitializableBeanDefinitionAndReference<T>
extends AbstractInitializableBeanDefinition<T>
implements BeanDefinitionReference<T> {
    private final Throwable failedInitialization;
    private final Condition[] preLoadConditions;
    private final Condition[] postLoadConditions;

    protected AbstractInitializableBeanDefinitionAndReference(Class<T> beanType, @Nullable AbstractInitializableBeanDefinition.MethodOrFieldReference constructor, @Nullable AnnotationMetadata annotationMetadata, @Nullable AbstractInitializableBeanDefinition.MethodReference[] methodInjection, @Nullable AbstractInitializableBeanDefinition.FieldReference[] fieldInjection, @Nullable AbstractInitializableBeanDefinition.AnnotationReference[] annotationInjection, @Nullable ExecutableMethodsDefinition<T> executableMethodsDefinition, @Nullable Map<String, Argument<?>[]> typeArgumentsMap, @NonNull AbstractInitializableBeanDefinition.PrecalculatedInfo precalculatedInfo) {
        this(beanType, constructor, annotationMetadata, methodInjection, fieldInjection, annotationInjection, executableMethodsDefinition, typeArgumentsMap, precalculatedInfo, null, null, null);
    }

    protected AbstractInitializableBeanDefinitionAndReference(Class<T> beanType, @Nullable AbstractInitializableBeanDefinition.MethodOrFieldReference constructor, @Nullable AnnotationMetadata annotationMetadata, @Nullable AbstractInitializableBeanDefinition.MethodReference[] methodInjection, @Nullable AbstractInitializableBeanDefinition.FieldReference[] fieldInjection, @Nullable AbstractInitializableBeanDefinition.AnnotationReference[] annotationInjection, @Nullable ExecutableMethodsDefinition<T> executableMethodsDefinition, @Nullable Map<String, Argument<?>[]> typeArgumentsMap, @NonNull AbstractInitializableBeanDefinition.PrecalculatedInfo precalculatedInfo, @Nullable Condition[] preLoadConditions, @Nullable Condition[] postLoadConditions, @Nullable Throwable failedInitialization) {
        super(beanType, constructor, annotationMetadata, methodInjection, fieldInjection, annotationInjection, executableMethodsDefinition, typeArgumentsMap, precalculatedInfo);
        this.failedInitialization = failedInitialization;
        this.preLoadConditions = preLoadConditions;
        this.postLoadConditions = postLoadConditions;
    }

    public final boolean isEnabled(BeanContext context, BeanResolutionContext resolutionContext, boolean preCheck) {
        if (this.preLoadConditions != null && this.postLoadConditions != null) {
            DefaultBeanContext defaultBeanContext = (DefaultBeanContext)context;
            DefaultConditionContext<AbstractBeanContextConditional> conditionContext = new DefaultConditionContext<AbstractBeanContextConditional>(defaultBeanContext, this, resolutionContext);
            boolean matches = preCheck ? AbstractInitializableBeanDefinitionAndReference.matches(conditionContext, this.preLoadConditions) : AbstractInitializableBeanDefinitionAndReference.matches(conditionContext, this.postLoadConditions);
            if (matches) {
                return true;
            }
            this.onFail(conditionContext, defaultBeanContext);
            return false;
        }
        if (preCheck) {
            return true;
        }
        return this.isEnabled(context, resolutionContext);
    }

    private static boolean matches(ConditionContext<?> conditionContext, Condition[] conditions) {
        for (Condition condition : conditions) {
            if (condition.matches(conditionContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String getBeanDefinitionName() {
        return this.getClass().getName();
    }

    @Override
    public final BeanDefinition<T> load(BeanContext context) {
        if (this.failedInitialization != null) {
            throw new BeanInstantiationException("Failed to initialize the bean [" + this.getBeanType() + "]: " + this.failedInitialization.getMessage(), this.failedInitialization);
        }
        BeanDefinition definition = this.load();
        if (definition instanceof EnvironmentConfigurable) {
            EnvironmentConfigurable environmentConfigurable = (EnvironmentConfigurable)((Object)definition);
            if (context instanceof DefaultApplicationContext) {
                DefaultApplicationContext applicationContext = (DefaultApplicationContext)context;
                environmentConfigurable.configure(applicationContext.getEnvironment());
            } else if (context instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)context;
                environmentConfigurable.configure(applicationContext.getEnvironment());
            }
        }
        if (definition instanceof BeanContextConfigurable) {
            BeanContextConfigurable ctxConfigurable = (BeanContextConfigurable)((Object)definition);
            ctxConfigurable.configure(context);
        }
        if (this.postLoadConditions != null) {
            for (int i = 0; i < this.postLoadConditions.length; ++i) {
                Condition postStartCondition = this.postLoadConditions[i];
                if (!(postStartCondition instanceof MatchesDynamicCondition)) continue;
                MatchesDynamicCondition matchesDynamicCondition = (MatchesDynamicCondition)postStartCondition;
                AnnotationMetadata annotationMetadata = EvaluatedAnnotationMetadata.wrapIfNecessary(matchesDynamicCondition.annotationMetadata());
                if (annotationMetadata instanceof EvaluatedAnnotationMetadata) {
                    EvaluatedAnnotationMetadata eam = (EvaluatedAnnotationMetadata)annotationMetadata;
                    eam.configure(context);
                    eam.setBeanDefinition(this);
                }
                this.postLoadConditions[i] = new MatchesDynamicCondition(annotationMetadata);
            }
        }
        return definition;
    }

    @Override
    public final boolean isPresent() {
        return true;
    }

    public int getOrder() {
        return 0;
    }
}

