/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.optim.StaticOptimizations;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;

@Internal
public class CachedEnvironment {
    private static final boolean LOCKED = StaticOptimizations.isEnvironmentCached();
    private static final Map<String, String> CACHED_ENVIRONMENT;
    private static final Map<Object, String> CACHED_PROPERTIES;
    private static UnaryOperator<String> getenv;

    @Nullable
    public static String getenv(String name) {
        if (LOCKED) {
            return CACHED_ENVIRONMENT.get(name);
        }
        return getenv == null ? System.getenv(name) : (String)getenv.apply(name);
    }

    @NonNull
    public static Map<String, String> getenv() {
        return LOCKED ? CACHED_ENVIRONMENT : System.getenv();
    }

    @Nullable
    public static String getProperty(String name) {
        return LOCKED ? CACHED_PROPERTIES.get(name) : System.getProperty(name);
    }

    static {
        if (LOCKED) {
            CACHED_ENVIRONMENT = Collections.unmodifiableMap(new HashMap<String, String>(System.getenv()));
            HashMap props = new HashMap();
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> props.put(key, String.valueOf(value))));
            CACHED_PROPERTIES = Collections.unmodifiableMap(props);
        } else {
            CACHED_ENVIRONMENT = Collections.emptyMap();
            CACHED_PROPERTIES = Collections.emptyMap();
        }
    }
}

