/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanContextConditional;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface BeanType<T>
extends AnnotationMetadataProvider,
BeanContextConditional,
BeanInfo<T> {
    default public boolean isPrimary() {
        return this.getAnnotationMetadata().hasDeclaredStereotype(Primary.class);
    }

    @NonNull
    public Class<T> getBeanType();

    default public Optional<String> getBeanName() {
        BeanType beanType = this;
        if (beanType instanceof NameResolver) {
            NameResolver nameResolver = (NameResolver)beanType;
            return nameResolver.resolveName();
        }
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        return annotationMetadata.findDeclaredAnnotation("jakarta.inject.Named").flatMap(AnnotationValue::stringValue);
    }

    default public boolean isContainerType() {
        return DefaultArgument.CONTAINER_TYPES.contains(this.getBeanType().getName());
    }

    @NonNull
    default public Set<Class<?>> getExposedTypes() {
        Object[] exposedTypes;
        String beanAnn;
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        if (annotationMetadata.hasDeclaredAnnotation(beanAnn = Bean.class.getName()) && ArrayUtils.isNotEmpty((Object[])(exposedTypes = annotationMetadata.classValues(beanAnn, "typed")))) {
            return Collections.unmodifiableSet(CollectionUtils.setOf((Object[])exposedTypes));
        }
        return Collections.emptySet();
    }

    default public boolean isCandidateBean(@Nullable Argument<?> beanType) {
        if (beanType == null) {
            return false;
        }
        Set<Class<?>> exposedTypes = this.getExposedTypes();
        if (CollectionUtils.isNotEmpty(exposedTypes)) {
            return exposedTypes.contains(beanType.getType());
        }
        Class<T> exposedType = this.getBeanType();
        return beanType.isAssignableFrom(exposedType) || beanType.getType() == exposedType || this.isContainerType();
    }

    default public String getName() {
        return this.getBeanType().getName();
    }

    default public boolean requiresMethodProcessing() {
        return false;
    }
}

