/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.OperatingSystem;
import io.micronaut.core.annotation.Internal;
import java.util.Objects;
import java.util.Set;

@Internal
public record MatchesCurrentOsCondition(Set<Requires.Family> os) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        Requires.Family currentOs = OperatingSystem.getCurrent().getFamily();
        if (!this.os.contains((Object)currentOs)) {
            context.fail("The current operating system [" + currentOs.name() + "] is not one of the required systems [" + String.valueOf(this.os) + "]");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesCurrentOsCondition that = (MatchesCurrentOsCondition)o;
        return Objects.equals(this.os, that.os);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.os);
    }

    @Override
    public String toString() {
        return "MatchesCurrentOsCondition{os=" + String.valueOf(this.os) + "}";
    }
}

