/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.OperatingSystem;
import io.micronaut.core.annotation.Internal;
import java.util.Objects;
import java.util.Set;

@Internal
public record MatchesCurrentNotOsCondition(Set<Requires.Family> notOs) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        Requires.Family currentOs = OperatingSystem.getCurrent().getFamily();
        if (this.notOs.contains((Object)currentOs)) {
            context.fail("The current operating system [" + currentOs.name() + "] is one of the disallowed systems [" + String.valueOf(this.notOs) + "]");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesCurrentNotOsCondition that = (MatchesCurrentNotOsCondition)o;
        return Objects.equals(this.notOs, that.notOs);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.notOs);
    }

    @Override
    public String toString() {
        return "MatchesCurrentNotOsCondition{notOs=" + String.valueOf(this.notOs) + "}";
    }
}

