/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ObjectUtils;
import java.util.Locale;

public abstract class AbstractMessageSource
implements MessageSource {
    private static final char QUOT = '\'';
    private static final char L_BRACE = '{';
    private static final char R_BRACE = '}';

    @Override
    @NonNull
    public String interpolate(@NonNull String template, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"template", (Object)template);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '\'') {
                int next = i + 1;
                if (next >= template.length()) continue;
                c = template.charAt(next);
                if (c == '\'') {
                    ++i;
                    builder.append('\'');
                    continue;
                }
                StringBuilder escaped = new StringBuilder();
                while (c != '\'') {
                    escaped.append(c);
                    if (++next >= template.length()) break;
                    c = template.charAt(next);
                }
                if (escaped.length() <= 0) continue;
                i = next;
                builder.append((CharSequence)escaped);
                continue;
            }
            if (c == '{') {
                StringBuilder variable = new StringBuilder();
                int next = i + 1;
                if (next < template.length()) {
                    c = template.charAt(next);
                    while (c != '}') {
                        variable.append(c);
                        if (++next >= template.length()) break;
                        c = template.charAt(next);
                    }
                    if (variable.length() <= 0) continue;
                    i = next;
                    String var = variable.toString();
                    if (c == '}') {
                        Object val = context.getVariables().get(var);
                        if (val != null) {
                            builder.append(val);
                            continue;
                        }
                        String resolved = this.getMessage(var, context).orElse(var);
                        builder.append(resolved);
                        continue;
                    }
                    builder.append('{').append(var);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    protected final class MessageKey {
        final Locale locale;
        final String code;

        public MessageKey(@NonNull Locale locale, String code) {
            this.locale = locale;
            this.code = code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageKey key = (MessageKey)o;
            return this.locale.equals(key.locale) && this.code.equals(key.code);
        }

        public int hashCode() {
            return ObjectUtils.hash((Object)this.locale, (Object)this.code);
        }
    }
}

