/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.OriginatingElements;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Internal
final class DefaultOriginatingElements
implements OriginatingElements {
    private final Map<String, Element> originatingElements;

    DefaultOriginatingElements(Element ... originatingElements) {
        this.originatingElements = new LinkedHashMap<String, Element>(originatingElements != null ? originatingElements.length : 5);
        if (originatingElements != null) {
            for (Element originatingElement : originatingElements) {
                if (originatingElement == null) continue;
                this.originatingElements.put(originatingElement.getName(), originatingElement);
            }
        }
    }

    @Override
    public void addOriginatingElement(@NotNull Element element) {
        Objects.requireNonNull(element, "Element cannot be null");
        this.originatingElements.put(element.getName(), element);
    }

    @Override
    @NotNull
    public Element[] getOriginatingElements() {
        return this.originatingElements.values().toArray(Element.EMPTY_ELEMENT_ARRAY);
    }
}

