/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.ast.DefaultElementQuery;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public interface ElementQuery<T extends Element> {
    public static final ElementQuery<FieldElement> ALL_FIELDS = ElementQuery.of(FieldElement.class);
    public static final ElementQuery<MethodElement> ALL_METHODS = ElementQuery.of(MethodElement.class);

    @NonNull
    public ElementQuery<T> onlyDeclared();

    @NonNull
    public ElementQuery<T> onlyConcrete();

    @NonNull
    public ElementQuery<T> onlyAbstract();

    @NonNull
    public ElementQuery<T> onlyAccessible();

    public ElementQuery<T> onlyInstance();

    @NonNull
    public ElementQuery<T> named(@NonNull Predicate<String> var1);

    @NonNull
    public ElementQuery<T> annotated(@NonNull Predicate<AnnotationMetadata> var1);

    @NonNull
    public ElementQuery<T> modifiers(@NonNull Predicate<Set<ElementModifier>> var1);

    @NonNull
    public ElementQuery<T> filter(@NonNull Predicate<T> var1);

    @NonNull
    public Result<T> result();

    @NonNull
    public static <T1 extends Element> ElementQuery<T1> of(@NonNull Class<T1> elementType) {
        return new DefaultElementQuery<T1>(Objects.requireNonNull(elementType, "Element type cannot be null"));
    }

    public static interface Result<T extends Element> {
        public boolean isOnlyAbstract();

        public boolean isOnlyConcrete();

        @NonNull
        public Class<T> getElementType();

        public boolean isOnlyAccessible();

        public boolean isOnlyDeclared();

        public boolean isOnlyInstance();

        @NonNull
        public List<Predicate<String>> getNamePredicates();

        @NonNull
        public List<Predicate<AnnotationMetadata>> getAnnotationPredicates();

        @NonNull
        public List<Predicate<Set<ElementModifier>>> getModifierPredicates();

        @NonNull
        public List<Predicate<T>> getElementPredicates();
    }
}

