/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@Internal
final class DefaultElementQuery<T extends Element>
implements ElementQuery<T>,
ElementQuery.Result<T> {
    private final Class<T> elementType;
    private final boolean onlyAccessible;
    private final boolean onlyDeclared;
    private final boolean onlyAbstract;
    private final boolean onlyConcrete;
    private final List<Predicate<String>> namePredicates;
    private final List<Predicate<AnnotationMetadata>> annotationPredicates;
    private final List<Predicate<Set<ElementModifier>>> modifiersPredicates;
    private final List<Predicate<T>> elementPredicates;
    private final boolean onlyInstance;

    DefaultElementQuery(Class<T> elementType) {
        this(elementType, false, false, false, false, false, null, null, null, null);
    }

    DefaultElementQuery(Class<T> elementType, boolean onlyAccessible, boolean onlyDeclared, boolean onlyAbstract, boolean onlyConcrete, boolean onlyInstance, List<Predicate<AnnotationMetadata>> annotationPredicates, List<Predicate<Set<ElementModifier>>> modifiersPredicates, List<Predicate<T>> elementPredicates, List<Predicate<String>> namePredicates) {
        this.elementType = elementType;
        this.onlyAccessible = onlyAccessible;
        this.onlyDeclared = onlyDeclared;
        this.onlyAbstract = onlyAbstract;
        this.onlyConcrete = onlyConcrete;
        this.namePredicates = namePredicates;
        this.annotationPredicates = annotationPredicates;
        this.modifiersPredicates = modifiersPredicates;
        this.elementPredicates = elementPredicates;
        this.onlyInstance = onlyInstance;
    }

    @Override
    public boolean isOnlyAbstract() {
        return this.onlyAbstract;
    }

    @Override
    public boolean isOnlyConcrete() {
        return this.onlyConcrete;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isOnlyAccessible() {
        return this.onlyAccessible;
    }

    @Override
    public boolean isOnlyDeclared() {
        return this.onlyDeclared;
    }

    @Override
    public boolean isOnlyInstance() {
        return this.onlyInstance;
    }

    @Override
    public List<Predicate<String>> getNamePredicates() {
        if (this.namePredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.namePredicates);
    }

    @Override
    public List<Predicate<AnnotationMetadata>> getAnnotationPredicates() {
        if (this.annotationPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.annotationPredicates);
    }

    @Override
    public List<Predicate<Set<ElementModifier>>> getModifierPredicates() {
        if (this.modifiersPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modifiersPredicates);
    }

    @Override
    public List<Predicate<T>> getElementPredicates() {
        if (this.elementPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.elementPredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> onlyDeclared() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, true, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> onlyConcrete() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, true, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> onlyAbstract() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, true, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> onlyAccessible() {
        return new DefaultElementQuery<T>(this.elementType, true, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    public ElementQuery<T> onlyInstance() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, true, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> named(@NotNull Predicate<String> predicate) {
        List<Predicate<String>> namePredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.namePredicates != null) {
            namePredicates = new ArrayList<Predicate<String>>(this.namePredicates);
            namePredicates.add(predicate);
        } else {
            namePredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> annotated(@NotNull Predicate<AnnotationMetadata> predicate) {
        List<Predicate<AnnotationMetadata>> annotationPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.annotationPredicates != null) {
            annotationPredicates = new ArrayList<Predicate<AnnotationMetadata>>(this.annotationPredicates);
            annotationPredicates.add(predicate);
        } else {
            annotationPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> modifiers(@NotNull Predicate<Set<ElementModifier>> predicate) {
        List<Predicate<Set<ElementModifier>>> modifierPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.modifiersPredicates != null) {
            modifierPredicates = new ArrayList<Predicate<Set<ElementModifier>>>(this.modifiersPredicates);
            modifierPredicates.add(predicate);
        } else {
            modifierPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, modifierPredicates, this.elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery<T> filter(@NotNull Predicate<T> predicate) {
        List<Predicate<T>> elementPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.elementPredicates != null) {
            elementPredicates = new ArrayList<Predicate<T>>(this.elementPredicates);
            elementPredicates.add(predicate);
        } else {
            elementPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessible, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInstance, this.annotationPredicates, this.modifiersPredicates, elementPredicates, this.namePredicates);
    }

    @Override
    @NotNull
    public ElementQuery.Result<T> result() {
        return this;
    }
}

