/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.aop.Around;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import java.lang.annotation.Annotation;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;

@Internal
class JavaBeanDefinitionBuilder
extends AbstractBeanDefinitionBuilder {
    private final JavaAnnotationMetadataBuilder annotationMetadataBuilder;

    JavaBeanDefinitionBuilder(Element originatingElement, ClassElement beanType, ElementAnnotationMetadataFactory elementAnnotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(originatingElement, beanType, (VisitorContext)visitorContext, elementAnnotationMetadataFactory);
        if (visitorContext.getVisitorKind() == TypeElementVisitor.VisitorKind.ISOLATING) {
            if (((Object)((Object)this)).getClass() == JavaBeanDefinitionBuilder.class) {
                visitorContext.addBeanDefinitionBuilder(this);
            }
        } else {
            visitorContext.fail("Cannot add bean definition using addAssociatedBean(..) from a AGGREGATING TypeElementVisitor, consider overriding getVisitorKind()", originatingElement);
        }
        this.annotationMetadataBuilder = visitorContext.getAnnotationMetadataBuilder();
    }

    protected @NonNull AbstractBeanDefinitionBuilder createChildBean(final FieldElement producerField) {
        final ClassElement parentType = this.getBeanType();
        return new JavaBeanDefinitionBuilder(this, this.getOriginatingElement(), producerField.getGenericField().getType(), this.elementAnnotationMetadataFactory, (JavaVisitorContext)this.visitorContext){

            public @NonNull Element getProducingElement() {
                return producerField;
            }

            public @NonNull ClassElement getDeclaringElement() {
                return producerField.getDeclaringType();
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                ClassElement newParent = parentType.withAnnotationMetadata(parentType.copyAnnotationMetadata());
                writer.visitBeanFactoryField(newParent, producerField.withAnnotationMetadata((AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{newParent.getDeclaredMetadata(), producerField.getDeclaredMetadata()})));
                return writer;
            }
        };
    }

    protected @NonNull BeanDefinitionVisitor createAopWriter(BeanDefinitionWriter beanDefinitionWriter, AnnotationMetadata annotationMetadata) {
        AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
        return new AopProxyWriter(this.getBeanType(), beanDefinitionWriter, annotationMetadata.getValues(Around.class, Boolean.class), this.visitorContext, interceptorTypes);
    }

    protected @NonNull BiConsumer<TypedElement, MethodElement> createAroundMethodVisitor(BeanDefinitionVisitor aopWriter) {
        AopProxyWriter aopProxyWriter = (AopProxyWriter)aopWriter;
        return (bean, method) -> {
            AnnotationValue[] newTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)method.getAnnotationMetadata(), (InterceptorKind)InterceptorKind.AROUND);
            aopProxyWriter.visitInterceptorBinding(newTypes);
            aopProxyWriter.visitAroundMethod(bean, method);
        };
    }

    protected @NonNull AbstractBeanDefinitionBuilder createChildBean(final MethodElement producerMethod) {
        final ClassElement parentType = this.getBeanType();
        return new JavaBeanDefinitionBuilder(this, this.getOriginatingElement(), producerMethod.getGenericReturnType(), this.elementAnnotationMetadataFactory, (JavaVisitorContext)this.visitorContext){
            BeanParameterElement[] parameters;

            public @NonNull Element getProducingElement() {
                return producerMethod;
            }

            public @NonNull ClassElement getDeclaringElement() {
                return producerMethod.getDeclaringType();
            }

            protected BeanParameterElement[] getParameters() {
                if (this.parameters == null) {
                    this.parameters = this.initBeanParameters(producerMethod.getParameters());
                }
                return this.parameters;
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                ClassElement newParent = parentType.withAnnotationMetadata(parentType.copyAnnotationMetadata());
                writer.visitBeanFactoryMethod(newParent, producerMethod.withAnnotationMetadata((AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{newParent.getDeclaredMetadata(), producerMethod.getDeclaredMetadata()})), (ParameterElement[])this.getParameters());
                return writer;
            }
        };
    }

    protected <T extends Annotation> void annotate(@NonNull AnnotationMetadata annotationMetadata, @NonNull AnnotationValue<T> annotationValue) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
        this.annotationMetadataBuilder.annotate(annotationMetadata, annotationValue);
    }

    protected <T extends Annotation> void annotate(AnnotationMetadata annotationMetadata, String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        consumer.accept(builder);
        AnnotationValue av = builder.build();
        this.annotationMetadataBuilder.annotate(annotationMetadata, av);
    }

    protected void removeStereotype(AnnotationMetadata annotationMetadata, String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        this.annotationMetadataBuilder.removeStereotype(annotationMetadata, annotationType);
    }

    protected <T extends Annotation> void removeAnnotationIf(AnnotationMetadata annotationMetadata, Predicate<AnnotationValue<T>> predicate) {
        ArgumentUtils.requireNonNull((String)"predicate", predicate);
        this.annotationMetadataBuilder.removeAnnotationIf(annotationMetadata, predicate);
    }

    protected void removeAnnotation(AnnotationMetadata annotationMetadata, String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        this.annotationMetadataBuilder.removeAnnotation(annotationMetadata, annotationType);
    }
}

