/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationsElement;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.AbstractElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public final class JavaElementAnnotationMetadataFactory
extends AbstractElementAnnotationMetadataFactory<javax.lang.model.element.Element, AnnotationMirror> {
    private static final ElementAnnotationMetadata EMPTY = new ElementAnnotationMetadata(){};

    public JavaElementAnnotationMetadataFactory(boolean isReadOnly, JavaAnnotationMetadataBuilder metadataBuilder) {
        super(isReadOnly, (AbstractAnnotationMetadataBuilder)metadataBuilder);
    }

    @NonNull
    public ElementAnnotationMetadataFactory readOnly() {
        return new JavaElementAnnotationMetadataFactory(true, (JavaAnnotationMetadataBuilder)this.metadataBuilder);
    }

    @NonNull
    public ElementAnnotationMetadata build(Element element) {
        AbstractJavaElement javaElement = (AbstractJavaElement)element;
        if (!JavaElementAnnotationMetadataFactory.allowedAnnotations(javaElement)) {
            return EMPTY;
        }
        return super.build(element);
    }

    private static boolean allowedAnnotations(AbstractJavaElement javaElement) {
        return javaElement.getNativeType().element() != null;
    }

    protected javax.lang.model.element.Element getNativeElement(Element element) {
        return ((AbstractJavaElement)element).getNativeType().element();
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForClass(ClassElement classElement) {
        JavaNativeElement.Class clazz = (JavaNativeElement.Class)classElement.getNativeType();
        TypeMirror typeMirror = clazz.typeMirror();
        if (typeMirror == null) {
            return super.lookupTypeAnnotationsForClass(classElement);
        }
        return this.metadataBuilder.lookupOrBuild((Object)clazz, (Object)new AnnotationsElement(typeMirror));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForGenericPlaceholder(GenericPlaceholderElement placeholderElement) {
        JavaNativeElement.Placeholder genericNativeType = (JavaNativeElement.Placeholder)placeholderElement.getGenericNativeType();
        TypeVariable placeholderTypeVariable = genericNativeType.typeVariable();
        javax.lang.model.element.Element placeholderJavaElement = !placeholderTypeVariable.getAnnotationMirrors().isEmpty() ? new AnnotationsElement(placeholderTypeVariable) : genericNativeType.element();
        return this.metadataBuilder.lookupOrBuild((Object)genericNativeType, (Object)placeholderJavaElement);
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForWildcard(WildcardElement wildcardElement) {
        WildcardType wildcard = (WildcardType)wildcardElement.getGenericNativeType();
        return this.metadataBuilder.lookupOrBuild((Object)wildcard, (Object)new AnnotationsElement(wildcard));
    }
}

