/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.annotation.WildcardElementAnnotationMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.type.WildcardType;

@Internal
final class JavaWildcardElement
extends JavaClassElement
implements WildcardElement {
    private final WildcardType wildcardType;
    private final JavaClassElement upperBound;
    private final List<JavaClassElement> upperBounds;
    private final List<JavaClassElement> lowerBounds;
    private final ElementAnnotationMetadata typeAnnotationMetadata;
    @Nullable
    private ElementAnnotationMetadata genericTypeAnnotationMetadata;

    JavaWildcardElement(ElementAnnotationMetadataFactory elementAnnotationMetadataFactory, @NonNull WildcardType wildcardType, @NonNull JavaClassElement mostUpper, @NonNull List<JavaClassElement> upperBounds, @NonNull List<JavaClassElement> lowerBounds) {
        super(mostUpper.getNativeType(), elementAnnotationMetadataFactory, mostUpper.visitorContext, mostUpper.typeArguments, mostUpper.getTypeArguments());
        this.wildcardType = wildcardType;
        this.upperBound = mostUpper;
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
        this.typeAnnotationMetadata = new WildcardElementAnnotationMetadata((WildcardElement)this, (ClassElement)this.upperBound);
    }

    public Optional<ClassElement> getResolved() {
        return Optional.of(this.upperBound);
    }

    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getGenericTypeAnnotationMetadata() {
        if (this.genericTypeAnnotationMetadata == null) {
            this.genericTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildGenericTypeAnnotations((GenericElement)this);
        }
        return this.genericTypeAnnotationMetadata;
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.getGenericTypeAnnotationMetadata();
    }

    @Override
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        return this.typeAnnotationMetadata;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getGenericTypeAnnotationMetadata()});
    }

    public Object getGenericNativeType() {
        return this.wildcardType;
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    @NonNull
    public List<? extends ClassElement> getUpperBounds() {
        return this.upperBounds;
    }

    @NonNull
    public List<? extends ClassElement> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions != 0) {
            throw new UnsupportedOperationException("Can't create array of wildcard");
        }
        return this;
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List<JavaClassElement> upperBounds = this.upperBounds.stream().map(ele -> this.toJavaClassElement(ele.foldBoundGenericTypes(fold))).toList();
        List<JavaClassElement> lowerBounds = this.lowerBounds.stream().map(ele -> this.toJavaClassElement(ele.foldBoundGenericTypes(fold))).toList();
        return fold.apply((ClassElement)(upperBounds.contains(null) || lowerBounds.contains(null) ? null : new JavaWildcardElement(this.elementAnnotationMetadataFactory, this.wildcardType, this.upperBound, upperBounds, lowerBounds)));
    }

    private JavaClassElement toJavaClassElement(ClassElement element) {
        if (element == null || element instanceof JavaClassElement) {
            return (JavaClassElement)element;
        }
        if (element.isWildcard() || element.isGenericPlaceholder()) {
            throw new UnsupportedOperationException("Cannot convert wildcard / free type variable to JavaClassElement");
        }
        return (JavaClassElement)((ArrayableClassElement)this.visitorContext.getClassElement(element.getName(), this.elementAnnotationMetadataFactory).orElseThrow(() -> new UnsupportedOperationException("Cannot convert ClassElement to JavaClassElement, class was not found on the visitor context"))).withArrayDimensions(element.getArrayDimensions()).withTypeArguments((Collection)element.getBoundGenericTypes());
    }
}

