/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.inject.visitor.PackageElementVisitor;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Internal
record PackageLoadedVisitor(@NonNull PackageElementVisitor<?> visitor, @NonNull String annotation) implements Ordered
{
    private static final String OBJECT_CLASS = Object.class.getName();

    public static PackageLoadedVisitor of(PackageElementVisitor<?> visitor, ProcessingEnvironment processingEnvironment) {
        Class classGeneric;
        Class[] classes;
        Class annotationClass;
        Class[] classes2;
        String annotationName;
        List<? extends TypeMirror> generics;
        Class<?> aClass = visitor.getClass();
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(aClass.getName());
        String annotation = typeElement != null ? ((generics = PackageLoadedVisitor.interfaceGenericTypesFor(typeElement, PackageElementVisitor.class.getName())).size() == 1 ? ((annotationName = generics.get(0).toString()).equals(OBJECT_CLASS) ? visitor.getPackageAnnotationName() : annotationName) : ((classes2 = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, PackageElementVisitor.class)) != null && classes2.length == 1 ? ((annotationClass = classes2[0]) == Object.class ? visitor.getPackageAnnotationName() : annotationClass.getName()) : Object.class.getName())) : ((classes = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, PackageElementVisitor.class)) != null && classes.length == 1 ? ((classGeneric = classes[0]) == Object.class ? visitor.getPackageAnnotationName() : classGeneric.getName()) : Object.class.getName());
        return new PackageLoadedVisitor(visitor, annotation);
    }

    private static List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    public int getOrder() {
        return this.visitor.getOrder();
    }

    public boolean matches(AnnotationMetadata annotationMetadata) {
        if (this.annotation.equals("java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.annotation);
    }
}

