/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class JavaConfigurationMetadataBuilder
extends ConfigurationMetadataBuilder<TypeElement> {
    private final AnnotationUtils annotationUtils;
    private final ModelUtils modelUtils;
    private final Elements elements;

    public JavaConfigurationMetadataBuilder(Elements elements, Types types, AnnotationUtils annotationUtils) {
        TypeElement epte;
        this.elements = elements;
        this.annotationUtils = annotationUtils;
        this.modelUtils = new ModelUtils(elements, types);
        TypeElement crte = elements.getTypeElement(ConfigurationReader.class.getName());
        if (crte != null) {
            this.getAnnotationMetadata(crte);
        }
        if ((epte = elements.getTypeElement(EachProperty.class.getName())) != null) {
            this.getAnnotationMetadata(epte);
        }
    }

    public Elements getElements() {
        return this.elements;
    }

    protected String buildPropertyPath(TypeElement owningType, TypeElement declaringType, String propertyName) {
        String value = this.buildTypePath(owningType, declaringType);
        return value + '.' + propertyName;
    }

    protected String buildTypePath(TypeElement owningType, TypeElement declaringType, AnnotationMetadata annotationMetadata) {
        Element enclosingElement;
        String initialPath = this.calculateInitialPath(owningType, annotationMetadata);
        StringBuilder path = new StringBuilder(initialPath);
        this.prependSuperclasses(declaringType, path);
        if (owningType.getNestingKind() == NestingKind.MEMBER && (enclosingElement = owningType.getEnclosingElement()) instanceof TypeElement) {
            AnnotationMetadata enclosingTypeMetadata;
            Optional parentConfig;
            TypeElement enclosingType = (TypeElement)enclosingElement;
            while ((parentConfig = (enclosingTypeMetadata = this.getAnnotationMetadata(enclosingType)).getValue(ConfigurationReader.class, String.class)).isPresent()) {
                Element el;
                String parentPath = this.pathEvaluationFunctionForMetadata(enclosingTypeMetadata).apply((String)parentConfig.get());
                path.insert(0, parentPath + '.');
                this.prependSuperclasses(enclosingType, path);
                if (enclosingType.getNestingKind() != NestingKind.MEMBER || !((el = enclosingType.getEnclosingElement()) instanceof TypeElement)) break;
                enclosingType = (TypeElement)el;
            }
        }
        return path.toString();
    }

    protected String buildTypePath(TypeElement owningType, TypeElement declaringType) {
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata(declaringType);
        return this.buildTypePath(owningType, declaringType, annotationMetadata);
    }

    private String calculateInitialPath(TypeElement owningType, AnnotationMetadata annotationMetadata) {
        Function<String, String> evaluatePathFunction = this.pathEvaluationFunctionForMetadata(annotationMetadata);
        return annotationMetadata.getValue(ConfigurationReader.class, String.class).map(evaluatePathFunction).orElseGet(() -> {
            AnnotationMetadata ownerMetadata = this.getAnnotationMetadata(owningType);
            return ownerMetadata.getValue(ConfigurationReader.class, String.class).map(this.pathEvaluationFunctionForMetadata(ownerMetadata)).orElseGet(() -> this.pathEvaluationFunctionForMetadata(annotationMetadata).apply(""));
        });
    }

    private Function<String, String> pathEvaluationFunctionForMetadata(AnnotationMetadata annotationMetadata) {
        return path -> {
            if (annotationMetadata.hasDeclaredAnnotation(EachProperty.class)) {
                if (annotationMetadata.booleanValue(EachProperty.class, "list").orElse(false).booleanValue()) {
                    return path + "[*]";
                }
                return path + ".*";
            }
            String prefix = annotationMetadata.getValue(ConfigurationReader.class, "prefix", String.class).orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                if (StringUtils.isEmpty((CharSequence)path)) {
                    return prefix;
                }
                return prefix + "." + path;
            }
            return path;
        };
    }

    protected String getTypeString(TypeElement type) {
        return this.modelUtils.resolveTypeReference(type).toString();
    }

    protected AnnotationMetadata getAnnotationMetadata(TypeElement type) {
        return this.annotationUtils.getAnnotationMetadata(type);
    }

    private void prependSuperclasses(TypeElement declaringType, StringBuilder path) {
        if (declaringType.getKind() == ElementKind.INTERFACE) {
            TypeElement element;
            AnnotationMetadata annotationMetadata;
            Optional parentConfig;
            DeclaredType superInterface = this.resolveSuperInterface(declaringType);
            while (superInterface instanceof DeclaredType && (parentConfig = (annotationMetadata = this.annotationUtils.getAnnotationMetadata(element = (TypeElement)superInterface.asElement())).getValue(ConfigurationReader.class, String.class)).isPresent()) {
                String parentPath = this.pathEvaluationFunctionForMetadata(annotationMetadata).apply((String)parentConfig.get());
                path.insert(0, parentPath + '.');
                superInterface = this.resolveSuperInterface(element);
            }
        } else {
            DeclaredType declaredType;
            Element element;
            AnnotationMetadata annotationMetadata;
            Optional parentConfig;
            TypeMirror superclass = declaringType.getSuperclass();
            while (superclass instanceof DeclaredType && (parentConfig = (annotationMetadata = this.annotationUtils.getAnnotationMetadata(element = (declaredType = (DeclaredType)superclass).asElement())).getValue(ConfigurationReader.class, String.class)).isPresent()) {
                String parentPath = this.pathEvaluationFunctionForMetadata(annotationMetadata).apply((String)parentConfig.get());
                path.insert(0, parentPath + '.');
                superclass = ((TypeElement)element).getSuperclass();
            }
        }
    }

    private DeclaredType resolveSuperInterface(TypeElement declaringType) {
        return declaringType.getInterfaces().stream().filter(tm -> tm instanceof DeclaredType && this.annotationUtils.getAnnotationMetadata(((DeclaredType)tm).asElement()).hasStereotype(ConfigurationReader.class)).map(dt -> (DeclaredType)dt).findFirst().orElse(null);
    }
}

