/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.util.HtmlSanitizer;
import jakarta.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@Singleton
@Requires(missingBeans={HtmlSanitizer.class})
public class HtmlEntityEncodingHtmlSanitizer
implements HtmlSanitizer {
    private final Map<String, String> encodedMap = new LinkedHashMap<String, String>();

    public HtmlEntityEncodingHtmlSanitizer() {
        this.encodedMap.put("&", "&amp;");
        this.encodedMap.put("<", "&lt;");
        this.encodedMap.put(">", "&gt;");
        this.encodedMap.put("\"", "&quot;");
        this.encodedMap.put("'", "&#x27;");
    }

    @Override
    public @NonNull String sanitize(@Nullable String html) {
        if (html == null) {
            return "";
        }
        String sanitized = html;
        for (Map.Entry<String, String> entry : this.encodedMap.entrySet()) {
            sanitized = sanitized.replaceAll(entry.getKey(), entry.getValue());
        }
        return sanitized;
    }
}

