/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.uri.DefaultUriBuilder;
import java.net.URI;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface UriBuilder {
    public @NonNull UriBuilder fragment(@Nullable String var1);

    public @NonNull UriBuilder scheme(@Nullable String var1);

    public @NonNull UriBuilder userInfo(@Nullable String var1);

    public @NonNull UriBuilder host(@Nullable String var1);

    public @NonNull UriBuilder port(int var1);

    public @NonNull UriBuilder path(@Nullable String var1);

    public @NonNull UriBuilder replacePath(@Nullable String var1);

    public @NonNull UriBuilder queryParam(String var1, Object ... var2);

    public @NonNull UriBuilder replaceQueryParam(String var1, Object ... var2);

    public @NonNull URI build();

    public @NonNull URI expand(Map<String, ? super Object> var1);

    public static @NonNull UriBuilder of(@NonNull URI uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        return new DefaultUriBuilder(uri);
    }

    public static @NonNull UriBuilder of(@NonNull CharSequence uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        return new DefaultUriBuilder(uri);
    }
}

