/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.ssl.PemParser;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class SslBuilder<T> {
    private final ResourceResolver resourceResolver;

    public SslBuilder(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public abstract Optional<T> build(SslConfiguration var1);

    public abstract Optional<T> build(SslConfiguration var1, HttpVersion var2);

    protected TrustManagerFactory getTrustManagerFactory(SslConfiguration ssl) {
        Optional<KeyStore> store;
        try {
            store = this.getTrustStore(ssl);
        }
        catch (SslConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SslConfigurationException(e);
        }
        return this.getTrustManagerFactory((KeyStore)store.orElse(null));
    }

    protected TrustManagerFactory getTrustManagerFactory(KeyStore store) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(store);
            return trustManagerFactory;
        }
        catch (SslConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getTrustStore(SslConfiguration ssl) throws Exception {
        SslConfiguration.TrustStoreConfiguration trustStore = ssl.getTrustStore();
        Optional<String> path = trustStore.getPath();
        if (path.isPresent()) {
            return Optional.of(this.loadCompat(new KeyStoreBasedCertificateSpec(trustStore.getType().orElse(null), trustStore.getPassword().orElse(null), trustStore.getProvider().orElse(null), path.get())));
        }
        return Optional.empty();
    }

    protected KeyManagerFactory getKeyManagerFactory(SslConfiguration ssl) {
        try {
            Optional<KeyStore> keyStore = this.getKeyStore(ssl);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Optional<String> password = ssl.getKey().getPassword();
            char[] keyPassword = password.map(String::toCharArray).orElse(null);
            Optional<String> pwd = ssl.getKeyStore().getPassword();
            if (keyPassword == null && pwd.isPresent()) {
                keyPassword = pwd.get().toCharArray();
            }
            keyManagerFactory.init(keyStore.orElse(null), keyPassword);
            return keyManagerFactory;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        SslConfiguration.KeyStoreConfiguration keyStore = ssl.getKeyStore();
        Optional<String> path = keyStore.getPath();
        if (path.isPresent()) {
            if (keyStore.getKeyPath() != null || keyStore.getCertificatePath() != null) {
                throw new SslConfigurationException("Cannot specify key store path and key-path or certificate-path at the same time");
            }
            return Optional.of(this.loadCompat(new KeyStoreBasedCertificateSpec(keyStore.getType().orElse(null), keyStore.getPassword().orElse(null), keyStore.getProvider().orElse(null), path.get())));
        }
        if (keyStore.getKeyPath() != null) {
            if (keyStore.getCertificatePath() == null) {
                throw new SslConfigurationException("Must also specify certificate-path");
            }
            return Optional.of(this.loadCompat(new PemBasedCertificateSpec(keyStore.getType().orElse(null), keyStore.getPassword().orElse(null), keyStore.getProvider().orElse(null), keyStore.getKeyPath(), keyStore.getCertificatePath())));
        }
        if (keyStore.getCertificatePath() != null) {
            throw new SslConfigurationException("Must also specify key-path");
        }
        return Optional.empty();
    }

    private KeyStore loadCompat(CertificateSpec spec) throws Exception {
        KeyStoreBasedCertificateSpec ks;
        if (spec instanceof KeyStoreBasedCertificateSpec && (ks = (KeyStoreBasedCertificateSpec)spec).getProvider() == null) {
            return this.load(Optional.ofNullable(ks.getType()), ks.getPath(), Optional.ofNullable(ks.getPassword()));
        }
        return this.load(spec);
    }

    @Deprecated(forRemoval=true)
    protected KeyStore load(Optional<String> optionalType, String resource, Optional<String> optionalPassword) throws Exception {
        return this.load(new KeyStoreBasedCertificateSpec(optionalType.orElse(null), optionalPassword.orElse(null), null, resource));
    }

    private static Supplier<SslConfigurationException> resourceNotFound(String resource) {
        return () -> new SslConfigurationException("The resource " + resource + " could not be found");
    }

    protected KeyStore load(CertificateSpec spec) throws Exception {
        if (spec instanceof KeyStoreBasedCertificateSpec) {
            KeyStoreBasedCertificateSpec ks = (KeyStoreBasedCertificateSpec)spec;
            KeyStore store = SslBuilder.createEmptyKeyStore(spec.provider, spec.type == null ? "JKS" : spec.type);
            InputStream stream = (InputStream)this.resourceResolver.getResourceAsStream(ks.path).orElseThrow(SslBuilder.resourceNotFound(ks.path));
            try {
                store.load(stream, spec.password == null ? null : spec.password.toCharArray());
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof UnrecoverableKeyException)) {
                    try {
                        if (spec.type == null) {
                            store = SslBuilder.createEmptyKeyStore(spec.provider, "PKCS12");
                        }
                        this.loadPem(ks.path, spec.password, spec.provider, store);
                    }
                    catch (PemParser.NotPemException f) {
                        e.addSuppressed(new Exception("Also tried and failed to load the input as PEM", f));
                        throw e;
                    }
                    catch (Exception f) {
                        f.addSuppressed(new Exception("Also tried and failed to load the input as a key store", e));
                        throw f;
                    }
                }
                throw e;
            }
            return store;
        }
        if (spec instanceof PemBasedCertificateSpec) {
            List<Object> certItems;
            List<Object> keyItems;
            PemBasedCertificateSpec pem = (PemBasedCertificateSpec)spec;
            try (InputStream s = (InputStream)this.resourceResolver.getResourceAsStream(pem.keyPath).orElseThrow(SslBuilder.resourceNotFound(pem.keyPath));){
                keyItems = new PemParser(pem.provider, pem.password).loadPem(new String(s.readAllBytes(), StandardCharsets.UTF_8));
            }
            try (InputStream s = (InputStream)this.resourceResolver.getResourceAsStream(pem.certificatePath).orElseThrow(SslBuilder.resourceNotFound(pem.certificatePath));){
                certItems = new PemParser(pem.provider, pem.password).loadPem(new String(s.readAllBytes(), StandardCharsets.UTF_8));
            }
            if (keyItems.size() != 1) {
                throw new SslConfigurationException("key-path contained more than one PEM object. It should only contain the private key.");
            }
            Object f = keyItems.get(0);
            if (!(f instanceof PrivateKey)) {
                throw new SslConfigurationException("key-path contained a certificate instead of a private key.");
            }
            PrivateKey pk = (PrivateKey)f;
            KeyStore store = SslBuilder.createEmptyKeyStore(spec.provider, spec.type == null ? "PKCS12" : spec.type);
            store.load(null, null);
            store.setKeyEntry("key", pk, null, SslBuilder.certificates(certItems).toArray(new X509Certificate[0]));
            return store;
        }
        throw new AssertionError((Object)"Weird CertificateSpec");
    }

    private static @NonNull KeyStore createEmptyKeyStore(@Nullable String provider, String type) throws KeyStoreException, NoSuchProviderException {
        return provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
    }

    private void loadPem(@NonNull String resource, @Nullable String password, @Nullable String provider, KeyStore store) throws IOException, GeneralSecurityException, PemParser.NotPemException {
        List<Object> items;
        try (InputStream s = (InputStream)this.resourceResolver.getResourceAsStream(resource).orElseThrow(SslBuilder.resourceNotFound(resource));){
            items = new PemParser(provider, password).loadPem(new String(s.readAllBytes(), StandardCharsets.UTF_8));
        }
        Object object = items.get(0);
        if (object instanceof PrivateKey) {
            PrivateKey pk = (PrivateKey)object;
            Certificate[] certs = SslBuilder.certificates(items.subList(1, items.size())).toArray(new X509Certificate[0]);
            store.load(null, null);
            store.setKeyEntry("key", pk, null, certs);
        } else if (items.get(0) instanceof X509Certificate) {
            store.load(null, null);
            List<X509Certificate> certificates = SslBuilder.certificates(items);
            for (int i = 0; i < certificates.size(); ++i) {
                store.setCertificateEntry("cert" + i, certificates.get(i));
            }
        } else {
            throw new SslConfigurationException("Unrecognized PEM entries");
        }
    }

    static List<X509Certificate> certificates(List<Object> pemObjects) {
        for (Object pemObject : pemObjects) {
            if (pemObject instanceof X509Certificate) continue;
            throw new SslConfigurationException("PEM must only contain the private key and a certificate chain");
        }
        return pemObjects;
    }

    protected static final class KeyStoreBasedCertificateSpec
    extends CertificateSpec {
        final String path;

        private KeyStoreBasedCertificateSpec(String type, String password, String provider, String path) {
            super(type, password, provider);
            this.path = path;
        }

        public @NonNull String getPath() {
            return this.path;
        }
    }

    protected static abstract sealed class CertificateSpec
    permits KeyStoreBasedCertificateSpec, PemBasedCertificateSpec {
        final String type;
        final String password;
        final String provider;

        private CertificateSpec(String type, String password, String provider) {
            this.type = type;
            this.password = password;
            this.provider = provider;
        }

        public @Nullable String getType() {
            return this.type;
        }

        public @Nullable String getPassword() {
            return this.password;
        }

        public @Nullable String getProvider() {
            return this.provider;
        }
    }

    protected static final class PemBasedCertificateSpec
    extends CertificateSpec {
        final String keyPath;
        final String certificatePath;

        private PemBasedCertificateSpec(String type, String password, String provider, String keyPath, String certificatePath) {
            super(type, password, provider);
            this.keyPath = keyPath;
            this.certificatePath = certificatePath;
        }

        public @NonNull String getKeyPath() {
            return this.keyPath;
        }

        public @NonNull String getCertificatePath() {
            return this.certificatePath;
        }
    }
}

