/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.ssl.AbstractClientSslConfiguration;
import io.micronaut.http.ssl.DefaultSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import jakarta.inject.Inject;
import org.jspecify.annotations.Nullable;

@ConfigurationProperties(value="micronaut.http.client.ssl")
@BootstrapContextCompatible
public class ClientSslConfiguration
extends AbstractClientSslConfiguration {
    public static final String PREFIX = "micronaut.http.client.ssl";

    @Inject
    public ClientSslConfiguration(DefaultSslConfiguration defaultSslConfiguration, DefaultSslConfiguration.DefaultKeyConfiguration defaultKeyConfiguration, DefaultSslConfiguration.DefaultKeyStoreConfiguration defaultKeyStoreConfiguration, SslConfiguration.TrustStoreConfiguration defaultTrustStoreConfiguration) {
        this.readExisting(defaultSslConfiguration, defaultKeyConfiguration, defaultKeyStoreConfiguration, defaultTrustStoreConfiguration);
        this.setEnabled(true);
    }

    public ClientSslConfiguration() {
        this.setEnabled(true);
    }

    @Inject
    void setKey(@Nullable DefaultKeyConfiguration keyConfiguration) {
        if (keyConfiguration != null) {
            super.setKey(keyConfiguration);
        }
    }

    @Inject
    void setKeyStore(@Nullable DefaultKeyStoreConfiguration keyStoreConfiguration) {
        if (keyStoreConfiguration != null) {
            super.setKeyStore(keyStoreConfiguration);
        }
    }

    @Inject
    void setTrustStore(@Nullable DefaultTrustStoreConfiguration trustStore) {
        if (trustStore != null) {
            super.setTrustStore(trustStore);
        }
    }

    @ConfigurationProperties(value="trust-store")
    @BootstrapContextCompatible
    @Requires(property="micronaut.http.client.ssl.trust-store")
    public static class DefaultTrustStoreConfiguration
    extends SslConfiguration.TrustStoreConfiguration {
    }

    @ConfigurationProperties(value="key-store")
    @BootstrapContextCompatible
    @Requires(property="micronaut.http.client.ssl.key-store")
    public static class DefaultKeyStoreConfiguration
    extends SslConfiguration.KeyStoreConfiguration {
    }

    @ConfigurationProperties(value="key")
    @BootstrapContextCompatible
    @Requires(property="micronaut.http.client.ssl.key")
    public static class DefaultKeyConfiguration
    extends SslConfiguration.KeyConfiguration {
    }
}

